package com.elitesland.fin.application.facade.vo.account;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@ApiModel(value = "账户表",description = "账户表")
@Data
public class AccountVO extends CustomFieldBaseModelVo {

    @ApiModelProperty("归属公司编码")
    private String secOuCode;

    @ApiModelProperty("归属公司名称")
    private String secOuName;

    @ApiModelProperty("开户主体类型")
    @SysCode(sys = "yst-fin", mod = "PRINCIPAL_TYPE")
    private String accountHolderType;

    @ApiModelProperty("开户主体类型名称")
    private String accountHolderTypeName;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    private String accountType;
    @ApiModelProperty("账户类型名称")
    private String accountTypeName;

    @ApiModelProperty("账户性质")
    private String accountNature;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String state;
    private String stateName;

    @ApiModelProperty("默认账户")
    private boolean defaultAccount;

    //old

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司类型")
    private String ouType;

    @ApiModelProperty("所属区域")
    private String area;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户名称编码")
    private String accNameCode;

    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    @ApiModelProperty("账户类型")
    private String accType;
    private String accTypeName;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accAvaAmt;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("区域id")
    private Long areaId;

}