package com.elitesland.fin.rpc.workflow;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Objects;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.dubbo.workflow
 * @date 2022/5/16 09:50
 */
@Service
@RequiredArgsConstructor
public class WorkflowRpcServiceImpl implements WorkflowRpcService {

    private final WorkflowService workflowService;

    private final SysSettingService sysSettingService;

    @Override
    public ProcessInfo startProcess(String procKey, String procInstName, String businessKey, HashMap<String, Object> variables) {

        if (checkIsEnableWorkFlow(procKey)) {
            WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(procKey, procInstName, businessKey, variables));
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
            }
            return processInfoWorkflowResult.getData();
        }

        return new ProcessInfo();
    }

    /**
     * 检查工作流是否启用
     *
     * @param workFlowKey 工作流key
     * @return
     */
    @Override
    public Boolean checkIsEnableWorkFlow(String workFlowKey) {
        SysSettingVO sysSetting = findSysSettingByNo(workFlowKey);
        return ObjectUtil.isNull(sysSetting) || FinConstant.ONE.equals(sysSetting.getSettingVal());
    }


    public SysSettingVO findSysSettingByNo(String no) {
        try {
            return sysSettingService.oneByNo(no);
        } catch (Exception e) {
            throw new com.elitescloud.boot.exception.BusinessException(ApiCode.FAIL, "查询系统设置表数据接口异常:" + e);
        }

    }

}
