/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.facade.vo.invoice;

import com.elitesland.fin.application.facade.vo.invoice.InvoiceApplyDetailRespVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@ApiModel(value="\u5f00\u7968\u7533\u8bf7\u8be6\u60c5")
public class InvoiceApplyRespVO
extends SaleInvVO {
    @ApiModelProperty(value="\u5f00\u7968\u660e\u7ec6\u884c")
    List<InvoiceApplyDetailRespVO> details;
    @ApiModelProperty(value="\u5f00\u7968\u660e\u7ec6\u6c47\u603b")
    List<InvoiceApplyDetailRespVO> summaryDetails;

    @JsonProperty
    public List<InvoiceApplyDetailRespVO> getSummaryDetails() {
        Map<String, List<InvoiceApplyDetailRespVO>> collect = this.details.stream().collect(Collectors.groupingBy(SaleInvDtlVO::getItemCode));
        ArrayList<InvoiceApplyDetailRespVO> result = new ArrayList<InvoiceApplyDetailRespVO>();
        collect.forEach((itemCode, details) -> {
            InvoiceApplyDetailRespVO row = (InvoiceApplyDetailRespVO)details.get(0);
            InvoiceApplyDetailRespVO curr = new InvoiceApplyDetailRespVO();
            curr.setId(row.getId());
            curr.setInvNature(row.getInvNature());
            curr.setInvNatureName(row.getInvNatureName());
            curr.setItemId(row.getItemId());
            curr.setItemCode(row.getItemCode());
            curr.setItemName(row.getItemName());
            curr.setTaxCode(row.getTaxCode());
            curr.setTaxName(row.getTaxName());
            curr.setItemType(row.getItemType());
            curr.setUom(row.getUom());
            curr.setUomName(row.getUomName());
            curr.setQty(this.add((List<InvoiceApplyDetailRespVO>)details, SaleInvDtlVO::getQty));
            BigDecimal priceTotal = this.add((List<InvoiceApplyDetailRespVO>)details, SaleInvDtlVO::getPrice);
            curr.setPrice(priceTotal.divide(curr.getQty(), 2, RoundingMode.HALF_UP));
            curr.setTotalAmt(this.add((List<InvoiceApplyDetailRespVO>)details, SaleInvDtlVO::getTotalAmt));
            curr.setTaxRate(row.getTaxRate());
            curr.setTaxAmt(this.add((List<InvoiceApplyDetailRespVO>)details, SaleInvDtlVO::getTaxAmt));
            curr.setExclTaxAmt(this.add((List<InvoiceApplyDetailRespVO>)details, SaleInvDtlVO::getExclTaxAmt));
            result.add(curr);
        });
        return result;
    }

    private BigDecimal add(List<InvoiceApplyDetailRespVO> details, Function<InvoiceApplyDetailRespVO, BigDecimal> func) {
        return details.stream().map(func).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public List<InvoiceApplyDetailRespVO> getDetails() {
        return this.details;
    }

    public void setDetails(List<InvoiceApplyDetailRespVO> details) {
        this.details = details;
    }

    public void setSummaryDetails(List<InvoiceApplyDetailRespVO> summaryDetails) {
        this.summaryDetails = summaryDetails;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceApplyRespVO)) {
            return false;
        }
        InvoiceApplyRespVO other = (InvoiceApplyRespVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<InvoiceApplyDetailRespVO> this$details = this.getDetails();
        List<InvoiceApplyDetailRespVO> other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        List<InvoiceApplyDetailRespVO> this$summaryDetails = this.getSummaryDetails();
        List<InvoiceApplyDetailRespVO> other$summaryDetails = other.getSummaryDetails();
        return !(this$summaryDetails == null ? other$summaryDetails != null : !((Object)this$summaryDetails).equals(other$summaryDetails));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InvoiceApplyRespVO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<InvoiceApplyDetailRespVO> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        List<InvoiceApplyDetailRespVO> $summaryDetails = this.getSummaryDetails();
        result = result * 59 + ($summaryDetails == null ? 43 : ((Object)$summaryDetails).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "InvoiceApplyRespVO(details=" + this.getDetails() + ", summaryDetails=" + this.getSummaryDetails() + ")";
    }
}

