package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎明细")
public class FinAccountEngineDetailsParam extends BaseModelParam {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序列号")
    private Integer serialNum;

    @ApiModelProperty("会计引擎名称")
    private String accountEngine;

    @ApiModelProperty("是否启用")
    private Boolean activeFlag;

    @ApiModelProperty("会计引擎条件")
    private List<FinAccEngDetConditionParam> finAccEngDetConditionDetailList;

    @ApiModelProperty("会计引擎条件")
    private List<FinAccEngDetDataParam> FinAccEngDetDataDetailList;

    @ApiModelProperty("拟定类型")
    private String proposedType;

    @ApiModelProperty("传帐类型")
    private String transferType;
}
