package com.elitesland.fin.application.web.flowrepair;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairRedoParam;
import com.elitesland.fin.application.facade.vo.flowrepair.CreditAccountFlowRepairVO;
import com.elitesland.fin.application.service.flowrepair.CreditAccountFlowRepairService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/creditAccountFlow/repair")
@RequiredArgsConstructor
@Api(value = "信用信用账户流水修复重算", tags = {"信用信用账户流水修复重算"})
public class CreditAccountFlowRepairController {

    private final CreditAccountFlowRepairService creditAccountFlowRepairService;

    @PostMapping("/page")
    @ApiOperation("信用账户流水修复重算分页查询")
    public ApiResult<PagingVO<CreditAccountFlowRepairVO>> page(@RequestBody CreditAccountFlowRepairPageParam pageParam) {
        var ret = creditAccountFlowRepairService.page(pageParam);
        return ApiResult.ok(ret);
    }

    @PostMapping("/save")
    @ApiOperation("信用账户流水修复重算保存")
    public ApiResult<Void> save(@RequestBody @Validated CreditAccountFlowRepairParam param) {
        creditAccountFlowRepairService.save(param);
        return ApiResult.ok();
    }

    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据信用账户流水修复重算ID批量删除")
    public ApiResult<List<Long>> deleteBatch(@RequestBody List<Long> ids) {
        creditAccountFlowRepairService.deleteBatch(ids);
        return ApiResult.ok(ids);
    }

    @PostMapping(value = "/repair/redo")
    @ApiOperation(value = "信用账户流水修复重算")
    public ApiResult<Void> repairRedo(@RequestBody CreditAccountFlowRepairRedoParam repairRedoParam) {
        creditAccountFlowRepairService.repairRedo(repairRedoParam);
        return ApiResult.ok();
    }

    @PostMapping("/removeFlowNoCacheBatch")
    @ApiOperation("根据流水号批量清空校验缓存")
    public ApiResult<Void> removeFlowNoCacheBatch(@RequestBody List<String> flowNoList) {
        creditAccountFlowRepairService.removeFlowNoCacheBatch(flowNoList);
        return ApiResult.ok();
    }

}
