/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.base;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.fin.domain.base.BaseRepo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public interface BaseService<E extends BaseModel, ID extends Serializable> {
    @Autowired
    public BaseRepo<E, ID> getDao();

    default public E save(E entity) {
        return (E)((BaseModel)this.getDao().save(entity));
    }

    default public Iterable<E> saveAll(Iterable<E> entities) {
        return this.getDao().saveAll(entities);
    }

    default public E saveAndFlush(E entity) {
        return (E)((BaseModel)this.getDao().saveAndFlush(entity));
    }

    default public E update(E entity) {
        return (E)((BaseModel)this.getDao().saveAndFlush(entity));
    }

    default public void delete(ID id) {
        if (this.getDao().existsById(id)) {
            this.getDao().deleteById(id);
        }
    }

    default public void delete(E entity) {
        this.getDao().delete(entity);
    }

    default public void deleteByCondition(E entity) {
        Page all;
        Example eExample = Example.of(entity);
        int current = 1;
        PageRequest pageable = PageRequest.of((int)(current - 1), (int)500);
        while (!CollectionUtils.isEmpty((Collection)(all = this.getDao().findAll(eExample, (Pageable)pageable)).getContent())) {
            this.getDao().deleteAll((Iterable)all);
            ++current;
            if (all.getContent().size() >= 500) continue;
            break;
        }
    }

    default public long count() {
        return this.getDao().count();
    }

    default public long count(Specification<E> specification) {
        return this.getDao().count(specification);
    }

    default public List<E> findAll() {
        return this.getDao().findAll();
    }

    default public List<E> findAll(Example<E> example) {
        return this.getDao().findAll(example);
    }

    default public E findOne(Example<E> example) {
        return (E)((BaseModel)this.getDao().findOne(example).orElse(null));
    }

    default public E findById(ID id) {
        return (E)((BaseModel)this.getDao().findById(id).orElse(null));
    }

    default public Page<E> findAll(Pageable pageable) {
        return this.getDao().findAll(pageable);
    }

    default public Page<E> findAll(Specification<E> specification, Pageable pageable) {
        return this.getDao().findAll(specification, pageable);
    }

    default public void flush() {
        this.getDao().flush();
    }
}

