/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.accountingengine;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSobAccountPeriodDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSobAccountPeriodParam;
import com.elitesland.fin.domain.entity.accountingengine.FinSobAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinSobAccountPeriodDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FinSobAccountPeriodRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QFinSobAccountPeriodDO qFinSobAccountPeriodDO = QFinSobAccountPeriodDO.finSobAccountPeriodDO;

    public List<FinSobAccountPeriodDTO> query(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        Predicate where = this.whereEq(finSobAccountPeriodParam);
        JPAQuery query = (JPAQuery)this.select(FinSobAccountPeriodDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        return query.fetch();
    }

    public PagingVO<FinSobAccountPeriodDTO> page(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        Predicate where = this.where(finSobAccountPeriodParam);
        JPAQuery query = (JPAQuery)this.select(FinSobAccountPeriodDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        BusinessSecurityUtil.where(query, FinSobAccountPeriodDO.class);
        finSobAccountPeriodParam.setPaging(query);
        finSobAccountPeriodParam.fillOrders(query, this.qFinSobAccountPeriodDO);
        List finAccountPeriodDTOList = query.fetch();
        return PagingVO.builder().total(query.fetchCount()).records(finAccountPeriodDTOList).build();
    }

    private Predicate where(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        LocalDateTime start = null;
        LocalDateTime end = null;
        if (finSobAccountPeriodParam != null && StringUtils.isNotBlank((CharSequence)finSobAccountPeriodParam.getYear())) {
            try {
                int i = Integer.parseInt(finSobAccountPeriodParam.getYear());
                if (i < 1000 || i > 9999) {
                    throw new BusinessException("\u8bf7\u8f93\u51654\u4f4d\u6709\u6548\u5e74");
                }
            }
            catch (NumberFormatException e) {
                throw new BusinessException("\u8bf7\u8f93\u51654\u4f4d\u6709\u6548\u5e74");
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            start = LocalDateTime.parse(finSobAccountPeriodParam.getYear() + "-01-01 00:00:00", formatter);
            end = LocalDateTime.parse(finSobAccountPeriodParam.getYear() + "-12-31 23:59:59", formatter);
        }
        return BaseRepoProc.PredicateBuilder.builder().andEq(finSobAccountPeriodParam.getId() != null, this.qFinSobAccountPeriodDO.id, (Object)finSobAccountPeriodParam.getId()).andLike(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getSobCode()), (StringExpression)this.qFinSobAccountPeriodDO.sobCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getSobCode())).andLike(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getSobName()), (StringExpression)this.qFinSobAccountPeriodDO.sobName, StringUtil.buildLikeString(finSobAccountPeriodParam.getSobName())).andLike(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getAccountPeriodCode()), (StringExpression)this.qFinSobAccountPeriodDO.accountPeriodCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getAccountPeriodCode())).andLike(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getAccountPeriodName()), (StringExpression)this.qFinSobAccountPeriodDO.accountPeriodName, StringUtil.buildLikeString(finSobAccountPeriodParam.getAccountPeriodName())).andEq(Objects.nonNull(finSobAccountPeriodParam.getOuId()), this.qFinSobAccountPeriodDO.ouId, (Object)finSobAccountPeriodParam.getOuId()).andLike(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getOuCode()), (StringExpression)this.qFinSobAccountPeriodDO.ouCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getOuCode())).andLike(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getOuName()), (StringExpression)this.qFinSobAccountPeriodDO.ouName, StringUtil.buildLikeString(finSobAccountPeriodParam.getOuName())).andLike(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getPeriodStyle()), (StringExpression)this.qFinSobAccountPeriodDO.periodStyle, StringUtil.buildLikeString(finSobAccountPeriodParam.getPeriodStyle())).andEq(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getStatus()), (SimpleExpression)this.qFinSobAccountPeriodDO.status, (Object)finSobAccountPeriodParam.getStatus()).andGoe(start != null, this.qFinSobAccountPeriodDO.activeStartTime, (Comparable)start).andLoe(end != null, this.qFinSobAccountPeriodDO.activeEndTime, (Comparable)end).build();
    }

    private Predicate whereEq(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(finSobAccountPeriodParam.getId() != null, this.qFinSobAccountPeriodDO.id, (Object)finSobAccountPeriodParam.getId()).andEq(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getSobCode()), (SimpleExpression)this.qFinSobAccountPeriodDO.sobCode, (Object)finSobAccountPeriodParam.getSobCode()).andEq(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getAccountPeriodCode()), (SimpleExpression)this.qFinSobAccountPeriodDO.accountPeriodCode, (Object)finSobAccountPeriodParam.getAccountPeriodCode()).andEq(StringUtils.isNotEmpty((CharSequence)finSobAccountPeriodParam.getOuCode()), (SimpleExpression)this.qFinSobAccountPeriodDO.ouCode, (Object)finSobAccountPeriodParam.getOuCode()).andEq(Objects.nonNull(finSobAccountPeriodParam.getOuId()), this.qFinSobAccountPeriodDO.ouId, (Object)finSobAccountPeriodParam.getOuId()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qFinSobAccountPeriodDO.id, this.qFinSobAccountPeriodDO.accountPeriodCode, this.qFinSobAccountPeriodDO.accountPeriodName, this.qFinSobAccountPeriodDO.status, this.qFinSobAccountPeriodDO.activeStartTime, this.qFinSobAccountPeriodDO.activeEndTime, this.qFinSobAccountPeriodDO.sobCode, this.qFinSobAccountPeriodDO.sobName, this.qFinSobAccountPeriodDO.ouId, this.qFinSobAccountPeriodDO.ouCode, this.qFinSobAccountPeriodDO.ouName, this.qFinSobAccountPeriodDO.periodStyle, this.qFinSobAccountPeriodDO.createTime, this.qFinSobAccountPeriodDO.creator, this.qFinSobAccountPeriodDO.modifyTime, this.qFinSobAccountPeriodDO.updater})).from((EntityPath)this.qFinSobAccountPeriodDO);
    }

    public FinSobAccountPeriodRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

