/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.financial;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.financial.QFinancialBillDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FinancialBillRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QFinancialBillDO qFinancialBillDO = QFinancialBillDO.financialBillDO;

    public PagingVO<FinancialBillDTO> page(FinancialBillPageParam financialBillPageParam) {
        List<Predicate> where = this.where(financialBillPageParam);
        JPAQuery query = (JPAQuery)this.select(FinancialBillDTO.class).where(ExpressionUtils.allOf(where));
        financialBillPageParam.setPaging(query);
        financialBillPageParam.fillOrders(query, this.qFinancialBillDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public void updateRed(List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)this.qFinancialBillDO).set((Path)this.qFinancialBillDO.redStatus, (Object)UdcEnum.FINANCIAL_BILL_RED_STATUS_ALREADY.getValueCode()).where(new Predicate[]{this.qFinancialBillDO.id.in(ids)}).execute();
    }

    private List<Predicate> where(FinancialBillPageParam financialBillPageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!CollectionUtils.isEmpty(financialBillPageParam.getIds())) {
            predicates.add((Predicate)this.qFinancialBillDO.id.in(financialBillPageParam.getIds()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getMsyWorkId())) {
            predicates.add((Predicate)this.qFinancialBillDO.msyWorkId.like("%" + financialBillPageParam.getMsyWorkId() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getMsyStoreId())) {
            predicates.add((Predicate)this.qFinancialBillDO.msyStoreId.like("%" + financialBillPageParam.getMsyStoreId() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getFranchiseeCode())) {
            predicates.add((Predicate)this.qFinancialBillDO.franchiseeCode.like("%" + financialBillPageParam.getFranchiseeCode() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getDocType())) {
            predicates.add((Predicate)this.qFinancialBillDO.docType.eq((Object)financialBillPageParam.getDocType()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getStoreType())) {
            predicates.add((Predicate)this.qFinancialBillDO.storeType.eq((Object)financialBillPageParam.getStoreType()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getStoreCode())) {
            predicates.add((Predicate)this.qFinancialBillDO.storeCode.eq((Object)financialBillPageParam.getStoreCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getOuCode())) {
            predicates.add((Predicate)this.qFinancialBillDO.ouCode.eq((Object)financialBillPageParam.getOuCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getProposedStatus())) {
            predicates.add((Predicate)this.qFinancialBillDO.proposedStatus.eq((Object)financialBillPageParam.getProposedStatus()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getPostingStatus())) {
            predicates.add((Predicate)this.qFinancialBillDO.postingStatus.eq((Object)financialBillPageParam.getPostingStatus()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getRedStatus())) {
            predicates.add((Predicate)this.qFinancialBillDO.redStatus.eq((Object)financialBillPageParam.getRedStatus()));
        }
        if (financialBillPageParam.getCreateTimeStart() != null) {
            predicates.add((Predicate)this.qFinancialBillDO.createTime.goe((Comparable)financialBillPageParam.getCreateTimeStart()));
        }
        if (financialBillPageParam.getCreateTimeEnd() != null) {
            predicates.add((Predicate)this.qFinancialBillDO.createTime.loe((Comparable)financialBillPageParam.getCreateTimeEnd()));
        }
        if (!StringUtils.isEmpty((CharSequence)financialBillPageParam.getMsyDataId())) {
            predicates.add((Predicate)this.qFinancialBillDO.msyDataId.like("%" + financialBillPageParam.getMsyDataId() + "%"));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qFinancialBillDO.id, this.qFinancialBillDO.modifyTime, this.qFinancialBillDO.modifyUserId, this.qFinancialBillDO.updater, this.qFinancialBillDO.createTime, this.qFinancialBillDO.createUserId, this.qFinancialBillDO.remark, this.qFinancialBillDO.deleteFlag, this.qFinancialBillDO.tenantId, this.qFinancialBillDO.tenantOrgId, this.qFinancialBillDO.secBuId, this.qFinancialBillDO.secOuId, this.qFinancialBillDO.secUserId, this.qFinancialBillDO.belongOrgId, this.qFinancialBillDO.auditDataVersion, this.qFinancialBillDO.msyWorkId, this.qFinancialBillDO.msyWorkName, this.qFinancialBillDO.msyDataId, this.qFinancialBillDO.msyPayNodeId, this.qFinancialBillDO.storeName, this.qFinancialBillDO.storeCode, this.qFinancialBillDO.outerStoreId, this.qFinancialBillDO.docType, this.qFinancialBillDO.msyStoreId, this.qFinancialBillDO.storeType, this.qFinancialBillDO.msyFranchiseeId, this.qFinancialBillDO.franchiseeCode, this.qFinancialBillDO.franchiseeName, this.qFinancialBillDO.projectNumber, this.qFinancialBillDO.paymentChannel, this.qFinancialBillDO.payOrderId, this.qFinancialBillDO.orderIdTt, this.qFinancialBillDO.orderIdWqf, this.qFinancialBillDO.receivingAccountTt, this.qFinancialBillDO.receivingAccountQb, this.qFinancialBillDO.ouCode, this.qFinancialBillDO.receivingAccount, this.qFinancialBillDO.receivingAccountName, this.qFinancialBillDO.paymentAccountQb, this.qFinancialBillDO.paymentAccountName, this.qFinancialBillDO.paymentAccountAmount, this.qFinancialBillDO.paymentDate, this.qFinancialBillDO.url, this.qFinancialBillDO.fileName, this.qFinancialBillDO.redSource, this.qFinancialBillDO.proposedStatus, this.qFinancialBillDO.redStatus, this.qFinancialBillDO.postingStatus, this.qFinancialBillDO.payOrderType})).from((EntityPath)this.qFinancialBillDO);
    }

    public FinancialBillRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

