package com.elitesland.fin.application.facade.dto.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "事件表单")
public class FinEventTableDTO extends BaseModelDTO {

    @ApiModelProperty("事件表单名称")
    private String eventTable;

    @ApiModelProperty("主机")
    private String host;

    @ApiModelProperty("端口")
    private String port;

    @ApiModelProperty("用户名")
    private String userName;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("数据库名称")
    private String databaseName;

    @ApiModelProperty("主表")
    private String masTable;

    @ApiModelProperty("子表")
    private String tableName;

    @ApiModelProperty("主表条件字段")
    private String masTableColumn;

    @ApiModelProperty("子表条件字段")
    private String tableColumn;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("主表排序配置")
    private String masTableOrder;

    @ApiModelProperty("子表排序配置")
    private String tableOrder;

    @ApiModelProperty("会计引擎单据编码字段")
    private String columnDocNum;

    @ApiModelProperty("会计引擎id")
    private Long engineId;

    @ApiModelProperty("事件表单条件")
    private List<FinEventTableConditionDTO> finEventTableConditionDetailList;

    @ApiModelProperty("事件表单明细")
    private List<FinEventTableLineDTO> finEventTableLineDetailList;

    @ApiModelProperty("拟定条件")
    private List<FinEventTableConditionDTO> finEventTableProposedConditionList;
}
