package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.excel.entity.AccountFlowExportEntity;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_ACCOUNT_FLOW_EXPORT;

@Service
@AllArgsConstructor
public class AccountFlowExportUsingParamServiceImpl implements DataExport<AccountFlowExportEntity, AccountFlowPageParam> {
    private final AccountFlowService accountFlowService;
    @Override
    public String getTmplCode() {
        return FIN_ACCOUNT_FLOW_EXPORT;
    }
    @Override
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_ACCOUNT_FLOW_LIST, businessObjectType = FinBusinessObjectConstant.FIN_ACCOUNT_FLOW,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "账户流水导出",operationCode = FinBusinessObjectConstant.FIN_ACCOUNT_FLOW_EXPORT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<AccountFlowExportEntity> executeExport(AccountFlowPageParam queryParam) {
        PagingVO<AccountFlowVO> accountFlowVOPagingVO = accountFlowService.page(queryParam);
        
        return PagingVO.<AccountFlowExportEntity>builder()
            .total(accountFlowVOPagingVO.getTotal())
            .records(ExcelConvertUtils.convertLoosely(accountFlowVOPagingVO.getRecords(), AccountFlowExportEntity.class))
            .build();
    }
}
