package com.elitesland.fin.domain.entity.apverconfig;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;
/**
 * @author zhiyu.he
 * @date 2022/4/6 16:37
 */
@Entity
@Table(name="ap_ver_config_dtl")
@org.hibernate.annotations.Table(appliesTo = "ap_ver_config_dtl", comment = "核销参数明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApVerConfigDtlDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = 1195024243886007466L;
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "field_name", columnDefinition = "varchar(32) comment '匹配字段名称'")
    private String fieldName;

    @Column(name = "field_no", columnDefinition = "varchar(32) comment '匹配字段编码'")
    private String fieldNo;

    @Column(name = "field_type", columnDefinition = "varchar(32) comment '匹配字段类型'")
    private String fieldType;

    @Column(name = "edit_flag", columnDefinition = "tinyint(1) comment '是否编辑'")
    private Boolean editFlag;

    @Column(name = "match_flag", columnDefinition = "tinyint(1) comment '是否匹配'")
    private Boolean matchFlag;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApVerConfigDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApVerConfigDtlDO entity = (ApVerConfigDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
