package com.elitesland.fin.domain.entity.paymentperiod;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "aging_range")
@org.hibernate.annotations.Table(appliesTo = "aging_range", comment = "账龄区间设置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class AgingRangeDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -4616827381027741059L;

    @Comment("账龄区间编码")
    @Column(name = "aging_range_code", columnDefinition = "varchar(64)")
    private String agingRangeCode;

    @Comment("账龄区间名称")
    @Column(name = "aging_range_name", columnDefinition = "varchar(100)")
    private String agingRangeName;

    @Comment("时间单位类型")
    @Column(name = "time_unit_type", columnDefinition = "varchar(32)")
    private String timeUnitType;

    @Comment("单位天数")
    @Column(name = "unit_days", columnDefinition = "varchar(32)")
    private String unitDays;

    @Comment("状态")
    @Column(name = "status", columnDefinition = "varchar(32)")
    private String status;

}
