package com.elitesland.fin.infr.dto.arorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalPruneZeroConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ArOrderExcelDTO implements Serializable {

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("应收单编号")
    private String arOrderNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("单据来源")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String createMode;
    private String createModeName;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("含税金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核日期")
    private LocalDateTime auditDate;

    @ApiModelProperty("汇率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否含税")
    private Boolean taxFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("核销状态")
    private String verStateName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("单据类型")
    private String arOrderType;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("SO代表正向RSO代表退货负向")
    private String docCls;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("结算方式")
    private String settlementTypeName;

    private String proposedStatusName;

    @ApiModelProperty("红冲状态")
    private Object redState;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("红冲单对应原单号")
    private String redSourceNo;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("小类编码")
    private String smallCateCode;

    @ApiModelProperty("小类名称")
    private String smallCateName;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("单价")
    private BigDecimal exclTaxPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税金额")
    private BigDecimal detailTotalAmt;

    @ApiModelProperty("不含税金额")
    private BigDecimal detailExclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal detailTaxAmt;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmt;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;

    @ApiModelProperty("收款协议名称")
    private String protocolName;

    @ApiModelProperty("明细来源单号")
    private String detailSourceNo;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    private String relevanceOuName;
}
