package com.elitesland.fin.infr.dto.expesne;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package
 * @date 2022/4/11 14:16
 */
@Data
public class ExpTypeDTO extends BaseModelDTO implements Serializable {

    private static final long serialVersionUID = -3837714278033734478L;
    private Long id;

    /*********商品信息**********/
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    private String itemCode;

    private String itemName;

    private String itemType;

    private String smallCateCode;

    private String smallCateName;

    private String uom;

    private String uomName;


    @ApiModelProperty("税码(进项)")
    private String taxCode;

    @ApiModelProperty("税率(进项)")
    private BigDecimal taxRate;

    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;
    /*********商品信息**********/

    private String ExpTypeCode;

    private String ExpTypeName;

    private Boolean enableFlag;

    private Boolean autoAudit;

    private Boolean defaultFlag;

    @ApiModelProperty("来源单据 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDoc;
    @ApiModelProperty(value = "来源单据名称")
    private String sourceDocName;

    @ApiModelProperty("来源单据类型 [UDC]yst-supp:DOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "DOC_TYPE")
    private String sourceDocType;
    @ApiModelProperty(value = "来源单据类型名称")
    private String sourceDocTypeName;

    @ApiModelProperty("来源单据状态 [UDC]yst-supp:DOC_STATUS")
    @SysCode(sys = "yst-supp", mod = "DOC_STATUS")
    private String sourceDocStatus;
    @ApiModelProperty(value = "来源单据状态名称")
    private String sourceDocStatusName;
}
