package com.elitesland.fin.application.facade.vo.account;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 天龙对账单 DTO
 *
 * @author elitesland
 */
@Data
@ApiModel("天龙对账单")
public class TcStatementAccountVO extends CustomFieldBaseModelVo {

//    @ApiModelProperty(value = "序号") // 新增：对应CSV的“序号”字段
    private Long id;

    @ApiModelProperty(value = "对账流水号") // 无对应CSV字段，保留原描述
    private String reconciliationNo;

    @ApiModelProperty(value = "店铺编号") // 修改：原“门店编号”改为“店铺编号”，对应CSV的“店铺编号”
    private String storeCode;

    @ApiModelProperty(value = "店铺名称") // 修改：原“门店名称”改为“店铺名称”，对应CSV的“店铺名称”
    private String storeName;

    @ApiModelProperty(value = "店铺经营类型") // 无对应CSV字段，保留原描述
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeBusinessType;

    @ApiModelProperty(value = "店铺经营类型") // 无对应CSV字段，保留原描述
    private String storeBusinessTypeName;

    @ApiModelProperty(value = "对账日期") // 保留原描述，与CSV的“对账日期”一致
    private LocalDate reconciliationDate;

    @ApiModelProperty(value = "拟定状态")
    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    private String draftStatus;

    private String draftStatusName;


    @ApiModelProperty(value = "传账状态") // 无对应CSV字段，保留原描述
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;

    private String transferStatusName;


    @ApiModelProperty(value = "对账任务") // 对应CSV的“对账任务”
    private String reconciliationType;

    @ApiModelProperty(value = "对账类型") // 对应CSV的“对账任务”
    private String reconciliationTypeName;

    @ApiModelProperty(value = "对账模式") // 保留原描述，与CSV的“对账模式”一致
    private String reconciliationMode;

    @ApiModelProperty(value = "A方总金额") // 保留原描述，与CSV的“A方总金额”一致
    private BigDecimal partyATotalAmount;

    @ApiModelProperty(value = "A方总笔数") // 保留原描述，与CSV的“A方总笔数”一致
    private Integer partyATotalCount;

    @ApiModelProperty(value = "B方总金额") // 保留原描述，与CSV的“B方总金额”一致
    private BigDecimal partyBTotalAmount;

    @ApiModelProperty(value = "B方总笔数") // 保留原描述，与CSV的“B方总笔数”一致
    private Integer partyBTotalCount;

    @ApiModelProperty(value = "平账笔数") // 保留原描述，与CSV的“平账笔数”一致
    private Integer balancedCount;

    @ApiModelProperty(value = "平账金额") // 保留原描述，与CSV的“平账金额”一致
    private BigDecimal balancedAmount;

    @ApiModelProperty(value = "A方单边笔数") // 保留原描述，与CSV的“A方单边笔数”一致
    private Integer partyASingleSideCount;

    @ApiModelProperty(value = "A方单边金额") // 保留原描述，与CSV的“A方单边金额”一致
    private BigDecimal partyASingleSideAmount;

    @ApiModelProperty(value = "B方单边笔数") // 保留原描述，与CSV的“B方单边笔数”一致
    private Integer partyBSingleSideCount;

    @ApiModelProperty(value = "B方单边金额") // 保留原描述，与CSV的“B方单边金额”一致
    private BigDecimal partyBSingleSideAmount;

    @ApiModelProperty(value = "错账笔数") // 修改：原“金额差异笔数”改为“错账笔数”，对应CSV的“错账笔数”
    private Integer amountDiffCount;

    @ApiModelProperty(value = "错账金额") // 修改：原“A方差异单金额”改为“错账金额”，对应CSV的“错账金额”
    private BigDecimal partyADiffAmount;

    @ApiModelProperty(value = "B方差异单金额") // 无对应CSV字段，保留原描述
    private BigDecimal partyBDiffAmount;

    @ApiModelProperty(value = "差异金额") // 无对应CSV字段，保留原描述
    private BigDecimal totalDiffAmount;

    @ApiModelProperty(value = "重复笔数") // 保留原描述，与CSV的“重复笔数”一致
    private Integer duplicateCount;

    @ApiModelProperty(value = "重复金额") // 保留原描述，与CSV的“重复金额”一致
    private BigDecimal duplicateAmount;

    @ApiModelProperty(value = "滚动对平笔数") // 保留原描述，与CSV的“滚动对平笔数”一致
    private Integer rollingBalancedCount;

    @ApiModelProperty(value = "滚动对平金额") // 保留原描述，与CSV的“滚动对平金额”一致
    private BigDecimal rollingBalancedAmount;

    @ApiModelProperty(value = "核销笔数") // 保留原描述，与CSV的“核销笔数”一致
    private Integer writeOffCount;

    @ApiModelProperty(value = "核销金额") // 保留原描述，与CSV的“核销金额”一致
    private BigDecimal writeOffAmount;

    @ApiModelProperty(value = "执行时间") // 修改：原“天财执行时间”改为“执行时间”，对应CSV的“执行时间”
    private LocalDateTime tiancaiExecTime;

    @ApiModelProperty(value = "同步时间") // 无对应CSV字段，保留原描述
    private LocalDateTime syncTime;

    @ApiModelProperty(value = "核销标识")
    private String wirteOffMark;

    @ApiModelProperty( value = "平账标识")
    private String accountBalancingMark;

}