package com.elitesland.fin.application.service.unionpay.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * @author sunxw
 * @description 银联工具类
 * @Date 2023/5/31
 */
@Slf4j
public class UnionPayUtil {

    /**
     * value数组转string
     * @param sourceMap 源map
     * @return
     */
    public static Map<String,String> valueArray2String(Map<String,String[]> sourceMap){
        Map<String,String> data = new HashMap<>();
        Iterator<Map.Entry<String, String[]>> iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()){
            Map.Entry<String, String[]> next = iterator.next();
            data.put(next.getKey(), StringUtils.join(next.getValue()));
        }
        return data;
    }

    /**
     * 表单字符串转化成 hashMap
     * @param orderInfo
     * @return
     */
    public static HashMap<String, String> form2Map(String orderInfo) {
        String listinfo[];
        HashMap<String, String> map = new HashMap<>();
        listinfo = orderInfo.split("&");
        for(String s : listinfo)
        {
            String list[]  = s.split("=");
            if(list.length>1)
            {
                map.put(list[0], list[1]);
            }
        }
        return map;
    }

}
