package com.elitesland.fin.application.service.writeoff;


import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPaySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyPayQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
public interface FinApPayVerApplyPayService {

    /**
     * 批量插入.
     *
     * @param masId    主表ID
     * @param saveList 数据集合
     */
    void createBatch(Long masId, List<FinApPayVerApplyPaySaveDTO> saveList);

    /**
     * 批量删除.
     *
     * @param masIds 主表ID集合
     */
    void deleteByMasId(Collection<Long> masIds);

    /**
     * 数据查询.
     *
     * @param masIds 主表ID集合
     * @return 数据集合
     */
    List<FinApPayVerApplyPayVO> listByMasIds(Collection<Long> masIds);

	/**
	 * 根据条件查询核销收款单明细
	 * @param query
	 * @return
	 */
	List<FinApPayVerApplyPayVO> listByQuery(FinApPayVerApplyPayQuery query);

	/**
	 * 通过第三方收款单号或者明细ID查询
	 * @param query
	 * @return
	 */
	List<FinApPayVerApplyPayVO> listByOutRecDocNoOrDId(FinApPayVerApplyQuery query);
}
