package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinEventTableLineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinEventTableVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleVO;
import com.elitesland.fin.application.service.accountingengine.FinEventTableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/event/table")
@RequiredArgsConstructor
@Api(value = "事件表单", tags = {"事件表单"})
public class FinEventTableController {

    private final FinEventTableService finEventTableService;
    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinEventTableParam finEventTableParam) {
        return ApiResult.ok(finEventTableService.saveOrUpdate(finEventTableParam));
    }

    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinEventTableVO>> page(@RequestBody FinEventTableParam finEventTableParam) {
        return ApiResult.ok(finEventTableService.page(finEventTableParam));
    }

    @PostMapping("enableOrDisable")
    @ApiOperation("启用/禁用")
    public ApiResult<Void> enableOrDisable(@RequestBody FinEventTableParam finEventTableParam) {
        finEventTableService.enableOrDisable(finEventTableParam);
        return ApiResult.ok();
    }

    @PostMapping("/loadDataTemplate")
    @ApiOperation("载入数据模板")
    public ApiResult<List<FinEventTableLineVO>> loadDataTemplate(@RequestBody FinEventTableParam finEventTableParam) {
        return ApiResult.ok(finEventTableService.loadDataTemplate(finEventTableParam));
    }
    @PostMapping("/pageEventTableLinesById")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinEventTableLineVO>> pageEventTableLinesById(@RequestBody FinEventTableLineParam finEventTableLineParam) {
        return ApiResult.ok(finEventTableService.queryEventTableLinesById(finEventTableLineParam));
    }
}
