package com.elitesland.fin.domain.expense;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/02
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "expense_type_dtl")
@org.hibernate.annotations.Table(appliesTo = "expense_type_dtl", comment = "费用类型配置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ExpTypeDtlDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -363588288411002143L;

    @Column(name = "source_line", columnDefinition = "int(10) comment '行号'")
    private Integer sourceLine;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @Column(name = "source_doc", columnDefinition = "varchar(32) comment '来源单据'")
    private String sourceDoc;

    @Column(name = "source_doc_type", columnDefinition = "varchar(32) comment '来源单据类型'")
    private String sourceDocType;

    @Column(name = "source_doc_status", columnDefinition = "varchar(32) comment '来源单据状态'")
    private String sourceDocStatus;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpTypeDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpTypeDtlDO entity = (ExpTypeDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
