package com.elitesland.fin.repo.invoice;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.PaymentChargesParamVO;
import com.elitesland.fin.application.facade.vo.invoice.PaymentChargesRespVO;
import com.elitesland.fin.application.facade.vo.invoice.PaymentChargesSaveVO;
import com.elitesland.fin.entity.invoice.QPaymentChargesDO;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * @author sunxw
 * @description
 * @Date 2023/8/10
 */
@Component
@RequiredArgsConstructor
public class PaymentChargesRepoProc {

    private static final QPaymentChargesDO qdo = QPaymentChargesDO.paymentChargesDO;
    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 分页查询
     * @param query 查询参数
     * @return
     */
    public PagingVO<PaymentChargesRespVO> queryPaging(PaymentChargesParamVO query) {
        JPAQuery<PaymentChargesRespVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PaymentChargesRespVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PaymentChargesRespVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<PaymentChargesRespVO> getList(PaymentChargesParamVO query){
        JPAQuery<PaymentChargesRespVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PaymentChargesRespVO> getJpaQueryWhere(PaymentChargesParamVO query) {
        JPAQuery<PaymentChargesRespVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getStoreCode())){
            jpaQuery.where(qdo.storeCode.eq(query.getStoreCode()));
        }
        if (!ObjectUtils.isEmpty(query.getFeeRuleCode())){
            jpaQuery.where(qdo.feeRuleCode.eq(query.getFeeRuleCode()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PaymentChargesRespVO> getJpaQuerySelect() {
        JPAQuery<PaymentChargesRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PaymentChargesRespVO.class,
                qdo.id,
                qdo.franchiseeId,
                qdo.storeCode,
                qdo.storeName,
                qdo.feeRuleCode,
                qdo.feeRuleName,
                qdo.totalChargesAmt,
                qdo.chargesPercent,
                qdo.creator,
                qdo.createUserId,
                qdo.modifyUserId,
                qdo.createTime,
                qdo.modifyTime,
                qdo.deleteFlag
        )).from(qdo)
                .where(qdo.deleteFlag.eq(0));
        return jpaQuery;
    }

    public void updateChargesPercent(PaymentChargesSaveVO saveVO){
        JPAUpdateClause jpaUpdateClause=jpaQueryFactory.update(qdo);
        if(!ObjectUtils.isEmpty(saveVO.getChargesPercent())){
            jpaUpdateClause.set(qdo.chargesPercent,saveVO.getChargesPercent());
        }
        jpaUpdateClause.where(qdo.id.eq(saveVO.getId()));
        jpaUpdateClause.execute();
    }

}
