/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.payorder;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.utils.BigDecimalUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayOrderDtlDomainServiceImpl
implements PayOrderDtlDomainService {
    private static final Logger log = LoggerFactory.getLogger(PayOrderDtlDomainServiceImpl.class);
    private final PayOrderDtlRepoProc payOrderDtlRepoProc;
    private final PayOrderDtlRepo payOrderDtlRepo;

    @Override
    public PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param) {
        return this.payOrderDtlRepoProc.page(param);
    }

    @Override
    public List<PayOrderDtlDTO> queryById(List<Long> ids) {
        return this.payOrderDtlRepoProc.queryById(ids);
    }

    @Override
    public List<PayOrderDtlDTO> queryBySourceIdList(List<Long> sourceIdList) {
        return this.payOrderDtlRepoProc.queryBySourceIdList(sourceIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Map<Long, BigDecimal> payDIdVerAmtMap, List<Long> payDIds) {
        List<PayOrderDtlDO> allByIdsIn = this.payOrderDtlRepoProc.findAllByIdsIn(payDIds);
        allByIdsIn.forEach(k -> {
            Long orderDtlId = k.getId();
            if (payDIdVerAmtMap.containsKey(orderDtlId)) {
                BigDecimal thisAmt = (BigDecimal)payDIdVerAmtMap.get(orderDtlId);
                k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).add(BigDecimalUtil.getUnify(thisAmt)));
                k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
            }
        });
        this.payOrderDtlRepo.saveAll(allByIdsIn);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resortVerAmt(Map<Long, BigDecimal> payDIdVerAmtMap, List<Long> payDIds) {
        List<PayOrderDtlDO> allByIdsIn = this.payOrderDtlRepoProc.findAllByIdsIn(payDIds);
        log.info("\u5f85\u56de\u5199\u6570\u636e1:{}", (Object)JSONUtil.toJsonStr(allByIdsIn));
        allByIdsIn.forEach(k -> {
            Long orderDtlId = k.getId();
            if (payDIdVerAmtMap.containsKey(orderDtlId)) {
                BigDecimal thisAmt = (BigDecimal)payDIdVerAmtMap.get(orderDtlId);
                k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).subtract(BigDecimalUtil.getUnify(thisAmt)));
                k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
            }
        });
        log.info("\u5f85\u56de\u5199\u6570\u636e2:{}", (Object)JSONUtil.toJsonStr(allByIdsIn));
        this.payOrderDtlRepo.saveAll(allByIdsIn);
    }

    @Override
    public List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds) {
        return this.payOrderDtlRepoProc.queryByMasId(masIds);
    }

    public PayOrderDtlDomainServiceImpl(PayOrderDtlRepoProc payOrderDtlRepoProc, PayOrderDtlRepo payOrderDtlRepo) {
        this.payOrderDtlRepoProc = payOrderDtlRepoProc;
        this.payOrderDtlRepo = payOrderDtlRepo;
    }
}

