package com.elitesland.fin.application.service.financial;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.FinancialBillConvert;
import com.elitesland.fin.application.convert.financial.FinancialBillDConvert;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDDTO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillSaveParam;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.financial.FinancialBillDDomainService;
import com.elitesland.fin.domain.service.financial.FinancialBillDomainService;
import com.elitesland.fin.entity.financial.FinancialBillDDO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.repo.financial.FinancialBillDRepo;
import com.elitesland.fin.repo.financial.FinancialBillRepo;
import com.elitesland.fin.repo.financial.FinancialBillRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreLicenseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2025/10/14 14:56
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FinancialBillServiceImpl implements FinancialBillService {

    private final FinancialBillDomainService financialBillDomainService;
    private final FinancialBillDDomainService financialBillDDomainService;
    private final SysUdcProxyService sysUdcProxyService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final FinancialBillRepo financialBillRepo;
    private final FinancialBillRepoProc financialBillRepoProc;
    private final FinancialBillDRepo financialBillDRepo;

    @SysCodeProc
    @Override
    public PagingVO<FinancialBillVO> pageSearch(FinancialBillPageParam financialBillPageParam) {
        PagingVO<FinancialBillVO> financialBillVOPagingVO = FinancialBillConvert.INSTANCE.convertPage(financialBillDomainService.page(financialBillPageParam));
        List<String> ouCodes = financialBillVOPagingVO.getRecords().stream().map(FinancialBillVO::getOuCode).collect(Collectors.toList());
        Map<String, String> ouMap = rmiOrgOuRpcServiceService.findBaseOuByCodes(ouCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, OrgOuRpcSimpleDTO::getOuName));
        financialBillVOPagingVO.getRecords().forEach(vo -> {
            if (ouMap.get(vo.getOuCode()) != null) {
                vo.setOuName(ouMap.get(vo.getOuCode()));
            }
        });
        return financialBillVOPagingVO;
    }

    @SysCodeProc
    @Override
    public FinancialBillVO get(Long id) {
        FinancialBillDTO financialBillDTO = financialBillDomainService.get(id);
        List<FinancialBillDDTO> financialBillDDTOS = financialBillDDomainService.queryByMasId(id);
        sysUdcProxyService.translate(financialBillDDTOS);
        financialBillDTO.setFinancialBillDList(financialBillDDTOS);
        return FinancialBillConvert.INSTANCE.dtoToVo(financialBillDTO);
    }

    @Transactional
    @Override
    public void batchSaveFinancialBill(List<FinancialBillSaveParam> param) {
        if (!CollectionUtils.isEmpty(param)) {
            List<FinancialBillDDO> dtlData = new ArrayList<>();
            param.forEach(vo -> {
                FinancialBillDO financialBillDO = FinancialBillConvert.INSTANCE.saveToDos(vo);
                Long save = financialBillDomainService.save(financialBillDO);
                vo.getFinancialBillDList().forEach(dtl -> {
                    FinancialBillDDO financialBillDDO = FinancialBillDConvert.INSTANCE.paramToDO(dtl);
                    financialBillDDO.setMasId(save);
                    dtlData.add(financialBillDDO);
                });
            });
            if (!CollectionUtils.isEmpty(dtlData)) {
                financialBillDDomainService.batchSaveFinancialBillD(dtlData);
            }
        }
    }

    @Transactional
    @Override
    public void autoRed() {
        //3、当门店主档传入时，中台自行去查询门店id对应的门店编码名称，此时门店需要有营业执照信息和开票信息，如果没有，轮询3，4，5。
        FinancialBillPageParam financialBillPageParam = new FinancialBillPageParam();
        financialBillPageParam.setSize(100000);
        financialBillPageParam.setRedStatus(UdcEnum.FINANCIAL_BILL_RED_STATUS_NONE.getValueCode());
        List<FinancialBillDTO> records = financialBillDomainService.page(financialBillPageParam).getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<String> storeIds = records.stream().map(FinancialBillDTO::getMsyStoreId).collect(Collectors.toList());
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setMsyStoreId(storeIds);
            List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOS = orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).getData();
            Map<String, OrgStoreBaseRpcDTO> storeMap = orgStoreBaseRpcDTOS.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getMsyStoreId, t -> t));


            List<String> storeId = orgStoreBaseRpcDTOS.stream().map(OrgStoreBaseRpcDTO::getMsyStoreId).collect(Collectors.toList());
            List<FinancialBillDTO> data=new ArrayList<>();
            //需要有营业执照才能继续生成
            records.forEach(vo->{
                if(storeMap.get(vo.getMsyStoreId())!=null){
                    Optional<OrgStoreLicenseRpcDTO> first = storeMap.get(vo.getMsyStoreId()).getOrgStoreLicenseRpcDTOS().stream()
                            .filter(v -> "YEZC".equals(v.getLicenseType())).findFirst();
                    if(first.isPresent()){
                        data.add(vo);
                    }
                }
            });

            if (!CollectionUtils.isEmpty(data)) {
                log.info("符合红冲的数据"+ JSONObject.toJSONString(data));
                List<Long> ids = data.stream().map(FinancialBillDTO::getId).collect(Collectors.toList());
                Map<Long, List<FinancialBillDDTO>> dtlMap = financialBillDDomainService.queryByMasIdIn(ids).stream().collect(Collectors.groupingBy(FinancialBillDDTO::getMasId));
                //4、先生成新的红冲加盟商账单，关联原加盟商账单。
                List<FinancialBillDDO> dtlData = new ArrayList<>();
                data.forEach(vo -> {
                    //加盟商
                    FinancialBillDO jms = FinancialBillConvert.INSTANCE.dtoToDo(vo);
                    jms.setRedStatus(UdcEnum.RED_STATE_NO.getValueCode());
                    jms.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
                    jms.setRedSource(vo.getMsyDataId());
                    //msyID设置空 防止校验
                    //jms.setMsyDataId(null);
                    jms.setId(null);
                    jms.setCreator(null);
                    jms.setCreateUserId(null);
                    jms.setCreateTime(null);
                    jms.setUpdater(null);
                    jms.setModifyUserId(null);
                    jms.setModifyTime(null);
                    jms.setPaymentAccountAmount(vo.getPaymentAccountAmount().multiply(new BigDecimal(-1)));
                    FinancialBillDO jmsSave = financialBillRepo.save(jms);
                    //门店
                    FinancialBillDO store = FinancialBillConvert.INSTANCE.dtoToDo(vo);
                    store.setRedStatus(UdcEnum.RED_STATE_NO.getValueCode());
                    store.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
                    store.setRedSource(vo.getMsyDataId());
                    store.setDocType(UdcEnum.FINANCIAL_BILL_TYPE_STORE.getValueCode());
                    //msyID设置空 防止校验
                    //store.setMsyDataId(null);
                    store.setId(null);
                    store.setCreator(null);
                    store.setCreateUserId(null);
                    store.setCreateTime(null);
                    store.setUpdater(null);
                    store.setModifyUserId(null);
                    store.setModifyTime(null);
                    store.setStoreCode(storeMap.get(vo.getMsyStoreId()).getStoreCode());
                    store.setStoreName(storeMap.get(vo.getMsyStoreId()).getStoreName());
                    FinancialBillDO storeSave = financialBillRepo.save(store);
                    if (!CollectionUtils.isEmpty(dtlMap.get(vo.getId()))) {
                        dtlMap.get(vo.getId()).forEach(dtl -> {
                            FinancialBillDDO jmsFinancialBillDDO = FinancialBillDConvert.INSTANCE.dtoToDo(dtl);
                            jmsFinancialBillDDO.setId(null);
                            jmsFinancialBillDDO.setCreator(null);
                            jmsFinancialBillDDO.setCreateUserId(null);
                            jmsFinancialBillDDO.setCreateTime(null);
                            jmsFinancialBillDDO.setUpdater(null);
                            jmsFinancialBillDDO.setModifyUserId(null);
                            jmsFinancialBillDDO.setModifyTime(null);
                            jmsFinancialBillDDO.setMasId(jmsSave.getId());
                            jmsFinancialBillDDO.setDetailActualAmount(dtl.getDetailActualAmount().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setDetailReductionAmount(dtl.getDetailReductionAmount().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setDetailStandardAmount(dtl.getDetailStandardAmount().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setAmt(dtl.getAmt().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setNetAmt(dtl.getNetAmt().multiply(new BigDecimal(-1)));
                            dtlData.add(jmsFinancialBillDDO);

                            FinancialBillDDO storeFinancialBillDDO = FinancialBillDConvert.INSTANCE.dtoToDo(dtl);
                            storeFinancialBillDDO.setId(null);
                            storeFinancialBillDDO.setCreator(null);
                            storeFinancialBillDDO.setCreateUserId(null);
                            storeFinancialBillDDO.setCreateTime(null);
                            storeFinancialBillDDO.setUpdater(null);
                            storeFinancialBillDDO.setModifyUserId(null);
                            storeFinancialBillDDO.setModifyTime(null);
                            storeFinancialBillDDO.setMasId(storeSave.getId());
                            dtlData.add(storeFinancialBillDDO);
                        });
                    }
                });
                //5、再生成门店账单。
                if (!CollectionUtils.isEmpty(dtlData)) {
                    financialBillDRepo.saveAll(dtlData);
                }
                //更新生成后红冲状态
                financialBillRepoProc.updateRed(ids);
            }

        }
    }
}
