package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplySettleConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplySettleVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplySettleDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplySettleRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 核销申请明细拆分.
 *
 * @author shihao.ma
 * @since 2023/9/19
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplySettleServiceImpl implements FinArRecVerApplySettleService {

    private final FinArRecVerApplySettleRepoProc finArRecVerApplySettleRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinArRecVerApplySettleSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }

        List<String> arDocNoList = saveList.stream().map(FinArRecVerApplySettleSaveDTO::getArDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ArOrderDTO> arOrderDTOList = arOrderRepoProc.selectInOutCustByArOrderNo(arDocNoList);
        Map<String, ArOrderDTO> arOrderMap = CollectionUtil.isEmpty(arOrderDTOList) ? new HashMap<>() : arOrderDTOList.stream().collect(Collectors.toMap(ArOrderDTO::getArOrderNo, t -> t, (t1, t2) -> t1));

        List<String> recDocNoList = saveList.stream().map(FinArRecVerApplySettleSaveDTO::getRecDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<RecOrderDTO> recOrderDTOList  = recOrderRepoProc.selectInOutCustByRecOrderNo(recDocNoList);
        Map<String, RecOrderDTO> recOrderMap = CollectionUtil.isEmpty(recOrderDTOList) ? new HashMap<>() : recOrderDTOList.stream().collect(Collectors.toMap(RecOrderDTO::getRecOrderNo, t -> t, (t1, t2) -> t1));


        finArRecVerApplySettleRepoProc.save(saveList.stream()
                .map(e -> {
                    FinArRecVerApplySettleDO entity = FinArRecVerApplySettleConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);

                    ArOrderDTO arOrderDTO = arOrderMap.get(entity.getArDocNo());
                    if (Objects.nonNull(arOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getArInOutCust()) ? arOrderDTO.getInOutCust() : entity.getArInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getArRelevanceOuCode()) ? arOrderDTO.getRelevanceOuCode() : entity.getArRelevanceOuCode();
                        String arCustCode = StringUtils.isBlank(entity.getArCustCode()) ? arOrderDTO.getCustCode() : entity.getArCustCode();

                        entity.setArInOutCust(inOutCust);
                        entity.setArRelevanceOuCode(relevanceOuCode);
                        entity.setArCustCode(arCustCode);
                    }

                    RecOrderDTO recOrderDTO = recOrderMap.get(entity.getRecDocNo());
                    if (Objects.nonNull(recOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getRecInOutCust()) ? recOrderDTO.getInOutCust() : entity.getRecInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getRecRelevanceOuCode()) ? recOrderDTO.getRelevanceOuCode() : entity.getRecRelevanceOuCode();
                        String recCustCode = StringUtils.isBlank(entity.getRecCustCode()) ? recOrderDTO.getCustCode() : entity.getRecCustCode();

                        entity.setRecInOutCust(inOutCust);
                        entity.setRecRelevanceOuCode(relevanceOuCode);
                        entity.setRecCustCode(recCustCode);
                    }

                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    public List<FinArRecVerApplySettleVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplySettleVO> finArRecVerApplySettleVOList = finArRecVerApplySettleRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplySettleConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());

        if (CollectionUtil.isEmpty(finArRecVerApplySettleVOList)){
            return Collections.EMPTY_LIST;
        }

        List<String> arRelevanceOuCodeList = finArRecVerApplySettleVOList.stream().map(FinArRecVerApplySettleVO::getArRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> recRelevanceOuCodeList = finArRecVerApplySettleVOList.stream().map(FinArRecVerApplySettleVO::getRecRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<String> relevanceOuCodeAllList = Stream.of(arRelevanceOuCodeList, recRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finArRecVerApplySettleVOList)){
            finArRecVerApplySettleVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouApRpcSimpleDTO = ouMap.get(v.getArRelevanceOuCode());
                if (Objects.nonNull(ouApRpcSimpleDTO)){
                    v.setArRelevanceOuName(ouApRpcSimpleDTO.getOuName());
                }

                OrgOuRpcSimpleDTO ouPayRpcSimpleDTO = ouMap.get(v.getRecRelevanceOuCode());
                if (Objects.nonNull(ouPayRpcSimpleDTO)){
                    v.setRecRelevanceOuName(ouPayRpcSimpleDTO.getOuName());
                }
            });
        }

        return finArRecVerApplySettleVOList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBatchNo(Collection<Long> masIds, String bachNo) {
        if (finArRecVerApplySettleRepoProc.updateBatchNo(masIds, bachNo) <=0) {
            throw new BusinessException("更新核销处理编号失败!");
        }
    }

	/**
	 * 更新核销处理核销类型
	 * @param masIds
	 * @param verFlag
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateVerFlag(Collection<Long> masIds, String verFlag) {
		if (finArRecVerApplySettleRepoProc.updateVerFlag(masIds, verFlag) <=0) {
			throw new BusinessException("更新核销处理编号失败!");
		}
	}

	/**
	 * 更新核销批次号-应收
	 * @param arDid
	 * @param batchNo
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByArDid(String arDid, String batchNo) {
		if (finArRecVerApplySettleRepoProc.updateBatchNoByArDid(arDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}

	/**
	 * 更新核销批次号-应收
	 * @param rcDid
	 * @param batchNo
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByRcDid(String rcDid, String batchNo) {
		if (finArRecVerApplySettleRepoProc.updateBatchNoByRcDid(rcDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}
}
