package com.elitesland.fin.domain.service.apverconfig;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigConvert;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigDtlConvert;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfig;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfigDO;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfigDtlDO;
import com.elitesland.fin.domain.param.apverconfig.ApVerConfigPageParam;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigDtlRepo;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigDtlRepoProc;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigRepo;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigRepoProc;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/6 16:11
 */
@Service
@RequiredArgsConstructor
public class ApVerConfigDomainServiceImpl implements ApVerConfigDomainService {

    private final ApVerConfigRepo apVerConfigRepo;

    private final ApVerConfigRepoProc apVerConfigRepoProc;

    private final ApVerConfigDtlRepo apVerConfigDtlRepo;

    private final ApVerConfigDtlRepoProc apVerConfigDtlRepoProc;

    private final SeqNumProvider sysNumberRuleService;


    @Transactional(rollbackFor = {Exception.class})
    @Override
    public String save(ApVerConfig apVerConfig) {
        //校验非空
        apVerConfig.checkNotNull();
        //设置默认值
        apVerConfig.defaultValue();
        //数据库第一条数据设置为默认  如果是修改不用设置是否默认
        if (apVerConfig.getId() == null) {
            apVerConfig.setDefaultFlag(!apVerConfigRepoProc.isFirst());
            Boolean nameByName = apVerConfigRepoProc.existNameByName(apVerConfig.getSchemeName());
            if(nameByName){
                throw new BusinessException("已存在的方案名称!");
            }
        }else{
            Boolean existNameById = apVerConfigRepoProc.existNameById(apVerConfig.getSchemeName(), apVerConfig.getId());
            if(existNameById){
                throw new BusinessException("已存在的方案名称!");
            }
        }

        return saveOrUpdate(apVerConfig).toString();
    }

    @Override
    public ApVerConfigDTO queryById(Long id) {
        ApVerConfigDTO apVerConfigDTO = apVerConfigRepoProc.queryById(id);
        List<ApVerConfigDtlDTO> configDtlDTOS = apVerConfigDtlRepoProc.queryByMasId(id);
        apVerConfigDTO.setApVerConfigDtlDTOList(configDtlDTOS);
        return apVerConfigDTO;
    }

    @Override
    public PagingVO<ApVerConfigDTO> page(ApVerConfigPageParam param) {
        return apVerConfigRepoProc.page(param);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void updateEnable(List<Long> ids,boolean state) {
        List<ApVerConfigDTO> apVerConfigDTOS = apVerConfigRepoProc.queryByIds(ids);
        if(state){
            apVerConfigDTOS.forEach(dto -> {
                if (dto.getEnableFlag()) {
                    throw new BusinessException("已启用状态不允许启用!");
                }
            });
        }else{
            apVerConfigDTOS.forEach(dto -> {
                if (!dto.getEnableFlag()) {
                    throw new BusinessException("已停用状态不允许停用!");
                }
            });
        }
        apVerConfigRepoProc.updateEnable(ids);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long updateDef(Long id) {
        ApVerConfigDTO apVerConfigDTO = apVerConfigRepoProc.queryById(id);
        if (apVerConfigDTO.getDefaultFlag()) {
            throw new BusinessException("已默认状态不允许再次默认!");
        }
        //先更新其他默认数据为否
        apVerConfigRepoProc.updateDefault();
        //更新自己为默认
        return apVerConfigRepoProc.updateDefaultById(id, true);
    }

    @Override
    public List<ApVerConfigDTO> queryAll() {
        return apVerConfigRepoProc.queryAll();
    }

    @Override
    public ApVerConfigDTO queryDef() {
        return apVerConfigRepoProc.queryDef();
    }

    @Override
    public List<ApVerConfigDTO> findByIds(List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return null;
        }
        List<ApVerConfigDO> apVerConfigDOS = apVerConfigRepo.findByIdIn(ids);
        if(CollectionUtils.isEmpty(apVerConfigDOS)){
            return null;
        }
        List<ApVerConfigDTO> configDTOS = apVerConfigDOS.stream().map(v -> ApVerConfigConvert
                .INSTANCE.convertDO2DTO(v)).collect(Collectors.toList());
        return configDTOS;
    }

    private Long saveOrUpdate(ApVerConfig apVerConfig) {
        ApVerConfigDO apVerConfigDO = ApVerConfigConvert.INSTANCE.convert(apVerConfig);
        //先删除明细
        if (apVerConfig.getId() != null) {
            apVerConfigDtlRepoProc.deleteByMasId(apVerConfig.getId());
        } else {
            String payOrderNo = sysNumberRuleService.generateCode(FinConstant.FIN,FinConstant.HXFA, null);
            apVerConfigDO.setSchemeNo(payOrderNo);
        }
        ApVerConfigDO configDO = apVerConfigRepo.save(apVerConfigDO);
        apVerConfig.getConfigDtlSaveParamList().forEach(dtl -> {
            dtl.setMasId(configDO.getId());
        });
        List<ApVerConfigDtlDO> apVerConfigDtlDOS = ApVerConfigDtlConvert.INSTANCE.convertDo(apVerConfig.getConfigDtlSaveParamList());
        apVerConfigDtlRepo.saveAll(apVerConfigDtlDOS);
        return configDO.getId();
    }
}
