package com.elitesland.fin.entity.account;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 * @desc : 天龙对账单
 */
@Entity
@Table(name = "tl_statement_account")
@org.hibernate.annotations.Table(appliesTo = "tl_statement_account", comment = "天龙对账单")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class TcStatementAccountDO extends CustomFieldBaseModel {

    @Column(name = "reconciliation_no", columnDefinition = "varchar(64) comment '对账流水号'")
    private String reconciliationNo;

    @Column(name = "store_code", columnDefinition = "varchar(32) comment '门店编号'")
    private String storeCode;

    @Column(name = "store_name", columnDefinition = "varchar(128) comment '门店名称'")
    private String storeName;

    @Column(name = "store_business_type", columnDefinition = "varchar(64) comment '门店经营性质'")
    private String storeBusinessType;

    @Column(name = "reconciliation_date", columnDefinition = "date comment '对账日期'")
    private LocalDate reconciliationDate;

    @Column(name = "draft_status", columnDefinition = "char(1) comment '拟定状态'")
    private String draftStatus;

    @Column(name = "transfer_status", columnDefinition = "char(1) comment '传账状态'")
    private String transferStatus;

    @Column(name = "reconciliation_type", columnDefinition = "char(1) comment '对账类型'")
    private String reconciliationType;

    @Column(name = "reconciliation_mode", columnDefinition = "char(1) comment '对账模式'")
    private String reconciliationMode;

    @Column(name = "party_a_total_amount", columnDefinition = "decimal(18,2) comment 'A方总金额'")
    private BigDecimal partyATotalAmount;

    @Column(name = "party_a_total_count", columnDefinition = "int comment 'A方总笔数'")
    private Integer partyATotalCount;

    @Column(name = "party_b_total_amount", columnDefinition = "decimal(18,2) comment 'B方总金额'")
    private BigDecimal partyBTotalAmount;

    @Column(name = "party_b_total_count", columnDefinition = "int comment 'B方总笔数'")
    private Integer partyBTotalCount;

    @Column(name = "balanced_count", columnDefinition = "int comment '平账笔数'")
    private Integer balancedCount;

    @Column(name = "balanced_amount", columnDefinition = "decimal(18,2) comment '平账金额'")
    private BigDecimal balancedAmount;

    @Column(name = "party_a_single_side_count", columnDefinition = "int comment 'A方单边笔数'")
    private Integer partyASingleSideCount;

    @Column(name = "party_a_single_side_amount", columnDefinition = "decimal(18,2) comment 'A方单边金额'")
    private BigDecimal partyASingleSideAmount;

    @Column(name = "party_b_single_side_count", columnDefinition = "int comment 'B方单边笔数'")
    private Integer partyBSingleSideCount;

    @Column(name = "party_b_single_side_amount", columnDefinition = "decimal(18,2) comment 'B方单边金额'")
    private BigDecimal partyBSingleSideAmount;

    @Column(name = "amount_diff_count", columnDefinition = "int comment '金额差异笔数'")
    private Integer amountDiffCount;

    @Column(name = "party_a_diff_amount", columnDefinition = "decimal(18,2) comment 'A方差异单金额'")
    private BigDecimal partyADiffAmount;

    @Column(name = "party_b_diff_amount", columnDefinition = "decimal(18,2) comment 'B方差异单金额'")
    private BigDecimal partyBDiffAmount;

    @Column(name = "total_diff_amount", columnDefinition = "decimal(18,2) comment '差异金额'")
    private BigDecimal totalDiffAmount;

    @Column(name = "duplicate_count", columnDefinition = "int comment '重复笔数'")
    private Integer duplicateCount;

    @Column(name = "duplicate_amount", columnDefinition = "decimal(18,2) comment '重复金额'")
    private BigDecimal duplicateAmount;

    @Column(name = "rolling_balanced_count", columnDefinition = "int comment '滚动对平笔数'")
    private Integer rollingBalancedCount;

    @Column(name = "rolling_balanced_amount", columnDefinition = "decimal(18,2) comment '滚动对平金额'")
    private BigDecimal rollingBalancedAmount;

    @Column(name = "write_off_count", columnDefinition = "int comment '核销笔数'")
    private Integer writeOffCount;

    @Column(name = "write_off_amount", columnDefinition = "decimal(18,2) comment '核销金额'")
    private BigDecimal writeOffAmount;

    @Column(name = "tiancai_exec_time", columnDefinition = "datetime comment '天财执行时间'")
    private LocalDateTime tiancaiExecTime;

    @Column(name = "sync_time", columnDefinition = "datetime comment '同步时间'")
    private LocalDateTime syncTime;

    @Column(name = "wirte_off_mark", columnDefinition = "char(1) comment '核销标记'")
    private String wirteOffMark;

    @Column(name = "account_balancing_mark", columnDefinition = "char(1) comment '平账标记'")
    private String accountBalancingMark;

}