package com.elitesland.fin.utils;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/12
 */
@Component
@RequiredArgsConstructor
public class FinIamUtil {


    /**
     * 当前登录用户
     *
     * @return 当前登录用户
     */
    public static SysUserDTO currentUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("未查询到用户信息，请先登录");
        }
        return userDetails.getUser();
    }

    /**
     * 获取当前登录用户的组织机构
     *
     * @return
     */
    public static String getUserOrgCode() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("未查询到用户信息，请先登录");
        }
        return userDetails.getUser().getOrg().getCode();
    }

    /**
     * 当前登录用户是否是业务员角色
     *
     * @return
     */
    public static Boolean isEmployee() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("未查询到用户信息，请先登录");
        }
        Set<String> roleCodes = userDetails.getUser().getRoleCodes();
        return roleCodes.contains("ROLE_employee");
    }

    /**
     * 当前登录人 - 用户名
     */
    public static String currentUserName() {
        String userName = SecurityContextUtil.currentUserName();
        if (ObjectUtil.isNull(userName)) {
            return "系统自动执行";
        }
        return userName;
    }

}
