/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.excel.account.AccountImportEntity;
import com.elitesland.fin.application.facade.param.account.AccountAppParam;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountSaveParam;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.vo.account.AccountAmtFlowVO;
import com.elitesland.fin.application.facade.vo.account.AccountAmtSumVO;
import com.elitesland.fin.application.facade.vo.account.AccountBankInfoVo;
import com.elitesland.fin.application.facade.vo.account.AccountOuVO;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.app.StoreAccountCustAppVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowAppVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.app.AppAccountService;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.ExcelEntityDataListener;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.AccountSnapshotDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.account.AccountSnapshotRepo;
import com.elitesland.fin.repo.account.AccountSnapshotRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccountServiceImpl
implements AccountService {
    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final SystemRpcService systemRpcService;
    private final UdcProvider udcProvider;
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final RmiSaleRpcService rmiSaleRpcService;
    private final AccountSnapshotRepoProc accountSnapshotRepoProc;
    private final AccountSnapshotRepo accountSnapshotRepo;
    private final FlexFieldUtilService flexFieldUtilService;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private AccountFlowService accountFlowService;
    private CreditAccountFlowService creditAccountFlowService;
    private final AppAccountService appAccountService;

    @Autowired
    @Lazy
    public void setAccountFlowService(AccountFlowService accountFlowService) {
        this.accountFlowService = accountFlowService;
    }

    @Autowired
    @Lazy
    public void setCreditAccountFlowService(CreditAccountFlowService creditAccountFlowService) {
        this.creditAccountFlowService = creditAccountFlowService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(AccountSaveParam accountSaveParam) {
        this.checkAccountSaveParam(accountSaveParam);
        if (ObjectUtil.isNull((Object)accountSaveParam.getId())) {
            Object accountCode = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "ZH", new ArrayList<String>());
            accountCode = accountSaveParam.getAccountHolderCode() + "-" + (String)accountCode;
            accountSaveParam.setAccountCode((String)accountCode);
            if (this.accountRepo.existsByAccountCode((String)accountCode)) {
                throw new BusinessException("\u8d26\u6237\u7f16\u7801\u5df2\u5b58\u5728");
            }
            if (this.accountRepo.existsBySecOuCodeAndAccountHolderCodeAndAccountType(accountSaveParam.getSecOuCode(), accountSaveParam.getAccountHolderCode(), accountSaveParam.getAccountType())) {
                throw new BusinessException("\u8be5\u5ba2\u6237\u5df2\u7ecf\u521b\u5efa\u8d26\u6237");
            }
            accountSaveParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        }
        AccountDO accountDO = AccountConvert.INSTANCE.saveParam2DO(accountSaveParam);
        this.flexFieldUtilService.handFlexFieldValueFeference("ACCOUNT", (Object)accountDO);
        this.accountRepo.save((Object)accountDO);
    }

    private void checkAccountSaveParam(AccountSaveParam accountSaveParam) {
        Assert.notEmpty((CharSequence)accountSaveParam.getSecOuCode(), (String)"\u5f52\u5c5e\u516c\u53f8\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountSaveParam.getAccountHolderName(), (String)"\u5f00\u6237\u4e3b\u4f53\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountSaveParam.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountSaveParam.getAccountHolderCode(), (String)"\u5f00\u6237\u4e3b\u4f53\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)accountSaveParam.getAccountAmount(), (String)"\u8d26\u6237\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)accountSaveParam.getAccountOccupancyAmount(), (String)"\u8d26\u6237\u5360\u7528\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)accountSaveParam.getAccountAvailableAmount(), (String)"\u8d26\u6237\u53ef\u7528\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
        Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
        if (!pattern.matcher(accountSaveParam.getAccountAmount().toString()).matches()) {
            Assert.notNull((Object)accountSaveParam.getAccountAmount(), (String)"\u8d26\u6237\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e,\u6700\u591a\u4e24\u4f4d\u5c0f\u6570", (Object[])new Object[0]);
        }
        if (!pattern.matcher(accountSaveParam.getAccountOccupancyAmount().toString()).matches()) {
            Assert.notNull((Object)accountSaveParam.getAccountAmount(), (String)"\u8d26\u6237\u5360\u7528\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e,\u6700\u591a\u4e24\u4f4d\u5c0f\u6570", (Object[])new Object[0]);
        }
        if (!pattern.matcher(accountSaveParam.getAccountAvailableAmount().toString()).matches()) {
            Assert.notNull((Object)accountSaveParam.getAccountAmount(), (String)"\u8d26\u6237\u53ef\u7528\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e,\u6700\u591a\u4e24\u4f4d\u5c0f\u6570", (Object[])new Object[0]);
        }
        Assert.isTrue((accountSaveParam.getAccountAmount().compareTo(accountSaveParam.getAccountOccupancyAmount().add(accountSaveParam.getAccountAvailableAmount())) == 0 ? 1 : 0) != 0, (String)"\u8d26\u6237\u91d1\u989d\u4e0d\u7b49\u4e8e\u8d26\u6237\u5360\u7528\u91d1\u989d+\u8d26\u6237\u53ef\u7528\u91d1\u989d", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void accountImport(MultipartFile file) throws IOException {
        ArrayList<String> errorList = new ArrayList<String>();
        ExcelEntityDataListener dataInternalListener = new ExcelEntityDataListener();
        ((ExcelReaderSheetBuilder)EasyExcelFactory.read((InputStream)file.getInputStream(), AccountImportEntity.class, dataInternalListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doRead();
        List<AccountImportEntity> accountImportEntityList = dataInternalListener.getDatas();
        Assert.notEmpty(accountImportEntityList, (String)"excel\u4e3a\u7a7a", (Object[])new Object[0]);
        accountImportEntityList.stream().forEach(item -> {
            if ("\u662f".equals(item.getDefaultAccount())) {
                item.setDefaultAccount("true");
            }
            if ("\u5426".equals(item.getDefaultAccount())) {
                item.setDefaultAccount("false");
            }
        });
        List<AccountDO> accountDOList = AccountConvert.INSTANCE.accountImportEntityList2AccountDOList(accountImportEntityList);
        this.buildErrorMsg(accountDOList, errorList);
        if (CollectionUtils.isNotEmpty(errorList)) {
            throw new BusinessException(StringUtils.join(errorList, (String)"\n"));
        }
        this.buildDefaultValue(accountDOList);
        this.accountRepo.saveAll(accountDOList);
    }

    public void buildDefaultValue(List<AccountDO> accountDOList) {
        accountDOList.stream().forEach(item -> {
            if (StringUtils.isNotEmpty((CharSequence)item.getAccountHolderType())) {
                item.setAccountHolderType(UdcEnum.PRINCIPAL_TYPE_INVOICE.getValueCode());
            }
        });
    }

    public void buildErrorMsg(List<AccountDO> accountDOList, List<String> errorList) {
        this.checkImportMandatoryField(accountDOList, errorList);
        this.checkImportRepeatAccountCode(accountDOList, errorList);
        this.checkDataValid(accountDOList, errorList);
    }

    public void checkDataValid(List<AccountDO> accountDOList, List<String> errorList) {
        List secOuCodeList = accountDOList.stream().map(AccountDO::getSecOuCode).collect(Collectors.toList());
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(secOuCodeList);
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(orgOuRpcDtoParam);
        Set ouCodeSet = orgOuRpcDTOList.stream().map(OrgOuRpcDTO::getOuCode).collect(Collectors.toSet());
        List secFranchiseeCodeList = accountDOList.stream().map(AccountDO::getSecFranchiseeCode).collect(Collectors.toList());
        Map principalTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.PRINCIPAL_TYPE_INVOICE.getModel(), UdcEnum.PRINCIPAL_TYPE_INVOICE.getCode());
        Collection principalTypeList = principalTypeUdc.values();
        Map finAccountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Collection finAccountTypeList = finAccountTypeUdc.values();
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getSecOuCode()) && !ouCodeSet.contains(accountDOList.get(i).getSecOuCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u516c\u53f8\u7f16\u7801", "\u516c\u53f8\u7f16\u7801\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
            }
            if (StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getAccountHolderType()) && !principalTypeList.contains(accountDOList.get(i).getAccountHolderType())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f00\u6237\u4e3b\u4f53\u7c7b\u578b", "\u5f00\u6237\u4e3b\u4f53\u7c7b\u578b\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
            }
            if (StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getAccountType()) && !finAccountTypeList.contains(accountDOList.get(i).getAccountType())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7c7b\u578b", "\u8d26\u6237\u7c7b\u578b\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
            }
            Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
            if (accountDOList.get(i).getAccountAmount() != null && !pattern.matcher(accountDOList.get(i).getAccountAmount().toString()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
            }
            if (accountDOList.get(i).getAccountOccupancyAmount() != null && !pattern.matcher(accountDOList.get(i).getAccountOccupancyAmount().toString()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u5360\u7528\u91d1\u989d", "\u8d26\u6237\u5360\u7528\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
            }
            if (accountDOList.get(i).getAccountAvailableAmount() != null && !pattern.matcher(accountDOList.get(i).getAccountAvailableAmount().toString()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u53ef\u7528\u91d1\u989d", "\u8d26\u6237\u53ef\u7528\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
            }
            if (accountDOList.get(i).getAccountAmount() == null || accountDOList.get(i).getAccountOccupancyAmount() == null || accountDOList.get(i).getAccountAvailableAmount() == null || accountDOList.get(i).getAccountAmount().compareTo(accountDOList.get(i).getAccountOccupancyAmount().add(accountDOList.get(i).getAccountAvailableAmount())) == 0) continue;
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u4e0d\u7b49\u4e8e\u8d26\u6237\u5360\u7528\u91d1\u989d+\u8d26\u6237\u53ef\u7528\u91d1\u989d"));
        }
    }

    private void checkImportRepeatAccountCode(List<AccountDO> accountDOList, List<String> errorList) {
        List allAccountDOList = this.accountRepo.findAll();
        Set accountCodeSet = allAccountDOList.stream().map(AccountDO::getAccountCode).collect(Collectors.toSet());
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (!accountCodeSet.contains(accountDOList.get(i).getAccountCode())) continue;
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5728\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728"));
        }
        HashSet<String> excelAccountCodeSet = new HashSet<String>();
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getAccountCode())) continue;
            if (excelAccountCodeSet.contains(accountDOList.get(i).getAccountCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u91cd\u590d"));
            }
            excelAccountCodeSet.add(accountDOList.get(i).getAccountCode());
        }
    }

    private void checkImportMandatoryField(List<AccountDO> accountDOList, List<String> errorList) {
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getSecOuCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f52\u5c5e\u516c\u53f8\u7f16\u7801", "\u5f52\u5c5e\u516c\u53f8\u7f16\u7801\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getSecFranchiseeCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f52\u5c5e\u52a0\u76df\u5546\u7f16\u7801", "\u5f52\u5c5e\u52a0\u76df\u5546\u7f16\u7801\u7f16\u7801\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountHolderName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f00\u6237\u4e3b\u4f53\u540d\u79f0", "\u5f00\u6237\u4e3b\u4f53\u540d\u79f0\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountType())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7c7b\u578b", "\u8d26\u6237\u7c7b\u578b\u5fc5\u586b"));
            }
            if (accountDOList.get(i).getAccountAmount() == null) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u5fc5\u586b"));
            }
            if (accountDOList.get(i).getAccountAvailableAmount() == null) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u53ef\u7528\u91d1\u989d", "\u8d26\u6237\u53ef\u7528\u91d1\u989d\u5fc5\u586b"));
            }
            if (accountDOList.get(i).getAccountOccupancyAmount() != null) continue;
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u5360\u7528\u91d1\u989d", "\u8d26\u6237\u5360\u7528\u91d1\u989d\u5fc5\u586b"));
        }
    }

    @Override
    @SysCodeProc
    public AccountVO get(Long id) {
        AccountVO res = this.accountRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = this.accountRepoProc.page(accountPageParam);
        if (CollectionUtils.isEmpty((Collection)res.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        ArrayList ouCodes = new ArrayList();
        res.getRecords().stream().forEach(item -> ouCodes.add(item.getSecOuCode()));
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(orgOuRpcDtoParam);
        res.getRecords().stream().forEach(item -> {
            OrgOuRpcDTO orgOuResult = orgOuRpcDTOList.stream().filter(orgOuRpcDTO -> StrUtil.equals((CharSequence)item.getSecOuCode(), (CharSequence)orgOuRpcDTO.getOuCode())).findFirst().orElse(null);
            if (orgOuResult != null) {
                item.setSecOuName(orgOuResult.getOuName());
            }
        });
        this.flexFieldUtilService.handleFlexFieldShowNameForVO("ACCOUNT", res.getRecords());
        return res;
    }

    @Override
    @SysCodeProc
    public List<AccountDTO> getAccountByAccountParam(AccountParam param) {
        return this.accountRepoProc.getAccountByAccountParam(param);
    }

    @Override
    @Transactional
    public Long updateState(AccountParam accountParam) {
        if (null == accountParam.getIds()) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long res = this.accountRepoProc.updateState(accountParam);
        return res;
    }

    @Override
    public List<AccountVO> queryAccount(List<String> accountCodes, String type, String state) {
        return this.accountRepoProc.queryByAccounts(accountCodes, type, state);
    }

    @Override
    public AccountVO getByCode(String accCode) {
        AccountVO res = this.accountRepoProc.getByCode(accCode);
        return res;
    }

    @Override
    @Transactional
    public Boolean updateAmtByCode(String accCode, BigDecimal accAmt, BigDecimal accOccAmt) {
        Assert.notEmpty((CharSequence)accCode, (String)"accCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AccountParam accountParam = new AccountParam();
        accountParam.setAccCode(accCode);
        accountParam.setAccAmt(accAmt);
        accountParam.setAccOccAmt(accOccAmt);
        if (null != accAmt && null != accOccAmt) {
            return this.accountRepoProc.updateAmtByCode(accountParam);
        }
        if (null != accAmt) {
            return this.accountRepoProc.updateAccAmtByCode(accountParam);
        }
        if (null != accOccAmt) {
            return this.accountRepoProc.updateOccAmtByCode(accountParam);
        }
        return true;
    }

    @Override
    public List<AccountBankInfoVo> getBankByCustCode(String custCode) {
        List<RmiOrgBankAccRpcVO> bankAccRpcVOS = this.rmiSaleRpcService.findBankAccByCustCode(custCode);
        if (CollectionUtil.isEmpty(bankAccRpcVOS)) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u94f6\u884c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e");
        }
        List<RmiOrgBankAccRpcVO> bankVos = bankAccRpcVOS.stream().filter(item -> StrUtil.equals((CharSequence)item.getAccType(), (CharSequence)"OUT")).collect(Collectors.toList());
        return AccountConvert.INSTANCE.rpcBankVos2Vos(bankVos);
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountSnapshotVo> querySnapshot(AccountSnapshotParam param) {
        PagingVO<AccountSnapshotVo> pagingVO = this.accountSnapshotRepoProc.querySnapshot(param);
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        ArrayList ouCodes = new ArrayList();
        pagingVO.getRecords().stream().forEach(item -> ouCodes.add(item.getSecOuCode()));
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(orgOuRpcDtoParam);
        pagingVO.getRecords().stream().forEach(item -> {
            OrgOuRpcDTO orgOuResult = orgOuRpcDTOList.stream().filter(orgOuRpcDTO -> StrUtil.equals((CharSequence)item.getSecOuCode(), (CharSequence)orgOuRpcDTO.getOuCode())).findFirst().orElse(null);
            if (orgOuResult != null) {
                item.setSecOuName(orgOuResult.getOuName());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)pagingVO.getRecords())) {
            this.flexFieldUtilService.handleFlexFieldShowNameForVO("ACCOUNT", pagingVO.getRecords());
        }
        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void accountSnapshot(String param) {
        LocalDateTime dateTime = LocalDateTime.now();
        List accountDOList = this.accountRepo.findAll();
        if (CollectionUtil.isEmpty((Collection)accountDOList)) {
            return;
        }
        List<AccountSnapshotDO> snapshotDOS = AccountConvert.INSTANCE.accountDos2Snapshots(accountDOList);
        snapshotDOS.stream().forEach(snapshot -> snapshot.setSnapshotTime(dateTime));
        this.accountSnapshotRepo.saveAll(snapshotDOS);
    }

    @Override
    @SysCodeProc
    public List<AccountSnapshotDO> selectAccountSnapshotByParam(AccountSnapshotParam queryParam) {
        List<AccountSnapshotDO> accountSnapshotDOList = this.accountSnapshotRepoProc.selectAccountSnapshotByParam(queryParam);
        if (CollectionUtils.isEmpty(accountSnapshotDOList)) {
            return Collections.EMPTY_LIST;
        }
        return accountSnapshotDOList;
    }

    @Override
    @SysCodeProc
    public List<AccountOuVO> selectOuByParam(AccountAppParam accountAppParam) {
        List<AccountOuVO> creditAccountOuList;
        this.selectCustByStore(accountAppParam);
        if (StringUtils.isBlank((CharSequence)accountAppParam.getCustCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        List<Object> accountOuAllList = new ArrayList<AccountOuVO>();
        List<AccountOuVO> accountOuList = this.accountRepoProc.selectAccountOuByAccountHolderCode(accountAppParam.getCustCode());
        if (CollectionUtil.isNotEmpty(accountOuList)) {
            accountOuAllList.addAll(accountOuList);
        }
        if (CollectionUtil.isNotEmpty(creditAccountOuList = this.creditAccountRepoProc.selectAccountOuByObjectCode(accountAppParam.getCustCode()))) {
            accountOuAllList.addAll(creditAccountOuList);
        }
        if (CollectionUtil.isEmpty(accountOuAllList)) {
            return Collections.EMPTY_LIST;
        }
        List<String> ouCodeAllList = accountOuAllList.stream().map(AccountOuVO::getOuCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(ouCodeAllList);
        accountOuAllList = accountOuAllList.stream().distinct().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AccountOuVO>(Comparator.comparing(AccountOuVO::getOuCode))), ArrayList::new));
        accountOuAllList = accountOuAllList.stream().sorted(Comparator.comparing(AccountOuVO::getCreateTime).reversed()).collect(Collectors.toList());
        accountOuAllList.forEach(accountOuVO -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(accountOuVO.getOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                accountOuVO.setOuId(ouRpcSimpleDTO.getId());
                accountOuVO.setOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return accountOuAllList;
    }

    @Override
    @SysCodeProc
    public AccountAmtSumVO selectAmtSumByParam(AccountAppParam accountAppParam) {
        this.selectCustByStore(accountAppParam);
        if (StringUtils.isBlank((CharSequence)accountAppParam.getCustCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)accountAppParam.getOuCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u516c\u53f8\u7f16\u53f7\u4e3a\u7a7a!");
        }
        AccountAmtSumVO amtSumVO = new AccountAmtSumVO();
        AccountAmtSumVO accountAmtSumVO = this.accountRepoProc.selectAmtSumByParam(accountAppParam.getOuCode(), accountAppParam.getCustCode());
        AccountAmtSumVO creditAccountAmtSumVO = this.creditAccountRepoProc.selectAmtSumByParam(accountAppParam.getOuCode(), accountAppParam.getCustCode());
        if (Objects.isNull(accountAmtSumVO) && Objects.isNull(creditAccountAmtSumVO)) {
            return amtSumVO;
        }
        BigDecimal accountAmountSum = BigDecimal.ZERO;
        BigDecimal accountOccupancyAmountSum = BigDecimal.ZERO;
        BigDecimal accountAvailableAmountSum = BigDecimal.ZERO;
        if (Objects.nonNull(accountAmtSumVO)) {
            if (Objects.nonNull(accountAmtSumVO.getAccountAmountSum())) {
                accountAmountSum = accountAmountSum.add(accountAmtSumVO.getAccountAmountSum());
            }
            if (Objects.nonNull(accountAmtSumVO.getAccountOccupancyAmountSum())) {
                accountOccupancyAmountSum = accountOccupancyAmountSum.add(accountAmtSumVO.getAccountOccupancyAmountSum());
            }
            if (Objects.nonNull(accountAmtSumVO.getAccountAvailableAmountSum())) {
                accountAvailableAmountSum = accountAvailableAmountSum.add(accountAmtSumVO.getAccountAvailableAmountSum());
            }
        }
        if (Objects.nonNull(creditAccountAmtSumVO)) {
            if (Objects.nonNull(creditAccountAmtSumVO.getAccountAmountSum())) {
                accountAmountSum = accountAmountSum.add(creditAccountAmtSumVO.getAccountAmountSum());
            }
            if (Objects.nonNull(creditAccountAmtSumVO.getCreditAccountUsedAmountSum())) {
                accountAmountSum = accountAmountSum.subtract(creditAccountAmtSumVO.getCreditAccountUsedAmountSum());
            }
            if (Objects.nonNull(creditAccountAmtSumVO.getAccountOccupancyAmountSum())) {
                accountOccupancyAmountSum = accountOccupancyAmountSum.add(creditAccountAmtSumVO.getAccountOccupancyAmountSum());
            }
            if (Objects.nonNull(creditAccountAmtSumVO.getAccountAvailableAmountSum())) {
                accountAvailableAmountSum = accountAvailableAmountSum.add(creditAccountAmtSumVO.getAccountAvailableAmountSum());
            }
        }
        amtSumVO.setAccountAmountSum(accountAmountSum);
        amtSumVO.setAccountAvailableAmountSum(accountAvailableAmountSum);
        amtSumVO.setAccountOccupancyAmountSum(accountOccupancyAmountSum);
        return amtSumVO;
    }

    @Override
    @SysCodeProc
    public AccountAmtFlowVO selectAccountAmtAndFlow(AccountAppParam accountAppParam) {
        this.selectCustByStore(accountAppParam);
        if (StringUtils.isBlank((CharSequence)accountAppParam.getCustCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)accountAppParam.getOuCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u516c\u53f8\u7f16\u53f7\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)accountAppParam.getAccountType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.nonNull(accountAppParam.getPreviousMonth())) {
            LocalDate localDate = LocalDate.now();
            LocalDate previousLocalDate = localDate.minus(accountAppParam.getPreviousMonth().intValue(), ChronoUnit.MONTHS);
            LocalDateTime transactionTimeS = LocalDateTime.of(previousLocalDate, LocalTime.MIN);
            LocalDateTime transactionTimeE = LocalDateTime.of(localDate, FinConstant.LOCAL_TIME_MAX);
            accountAppParam.setTransactionTimeS(transactionTimeS);
            accountAppParam.setTransactionTimeE(transactionTimeE);
        }
        AccountAmtFlowVO accountAmtFlowVO = new AccountAmtFlowVO();
        accountAmtFlowVO.setFlowPagingVO((PagingVO<AccountFlowAppVO>)PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build());
        if (Objects.equals(accountAppParam.getAccountType(), UdcEnum.ACCOUNT_TYPE_STORE.getValueCode()) || Objects.equals(accountAppParam.getAccountType(), UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode())) {
            List<AccountVO> accountVOList = this.accountRepoProc.selectAccountAmtByParam(accountAppParam.getOuCode(), accountAppParam.getCustCode(), accountAppParam.getAccountType());
            if (CollectionUtil.isEmpty(accountVOList)) {
                return accountAmtFlowVO;
            }
            if (accountVOList.size() > 1) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237+\u516c\u53f8+\u8d26\u6237\u7c7b\u578b\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237\u4fe1\u606f!");
            }
            AccountVO accountVO = accountVOList.get(0);
            accountAmtFlowVO.setAccountCode(accountVO.getAccountCode());
            accountAmtFlowVO.setAccountName(accountVO.getAccountName());
            accountAmtFlowVO.setAccountType(accountVO.getAccountType());
            BigDecimal accountAvailableAmount = Objects.isNull(accountVO.getAccountAvailableAmount()) ? BigDecimal.ZERO : accountVO.getAccountAvailableAmount();
            BigDecimal accountOccupancyAmount = Objects.isNull(accountVO.getAccountOccupancyAmount()) ? BigDecimal.ZERO : accountVO.getAccountOccupancyAmount();
            BigDecimal accountAmount = accountOccupancyAmount.add(accountAvailableAmount);
            accountAmtFlowVO.setAccountAmount(accountAmount);
            accountAmtFlowVO.setAccountAvailableAmount(accountVO.getAccountAvailableAmount());
            accountAmtFlowVO.setAccountOccupancyAmount(accountVO.getAccountOccupancyAmount());
            this.selectAccountFlow(accountAmtFlowVO, accountAppParam);
        } else if (Objects.equals(accountAppParam.getAccountType(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode())) {
            List<CreditAccountDTO> creditAccountDTOList = this.creditAccountRepoProc.selectCreditAccountAmtByParam(accountAppParam.getOuCode(), accountAppParam.getCustCode(), accountAppParam.getAccountType());
            if (CollectionUtil.isEmpty(creditAccountDTOList)) {
                return accountAmtFlowVO;
            }
            if (creditAccountDTOList.size() > 1) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237+\u516c\u53f8+\u8d26\u6237\u7c7b\u578b\u67e5\u8be2\u5230\u591a\u6761\u4fe1\u7528\u8d26\u6237\u4fe1\u606f!");
            }
            CreditAccountDTO creditAccountDTO = creditAccountDTOList.get(0);
            accountAmtFlowVO.setAccountCode(creditAccountDTO.getCreditAccountCode());
            accountAmtFlowVO.setAccountName(creditAccountDTO.getCreditAccountName());
            accountAmtFlowVO.setAccountType(creditAccountDTO.getCreditAccountType());
            BigDecimal creditAccountAvailableLimit = Objects.isNull(creditAccountDTO.getCreditAccountAvailableLimit()) ? BigDecimal.ZERO : creditAccountDTO.getCreditAccountAvailableLimit();
            BigDecimal creditAccountOccupancyLimit = Objects.isNull(creditAccountDTO.getCreditAccountOccupancyLimit()) ? BigDecimal.ZERO : creditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal accountAmount = creditAccountOccupancyLimit.add(creditAccountAvailableLimit);
            accountAmtFlowVO.setAccountAmount(accountAmount);
            accountAmtFlowVO.setAccountAvailableAmount(creditAccountDTO.getCreditAccountAvailableLimit());
            accountAmtFlowVO.setAccountOccupancyAmount(creditAccountDTO.getCreditAccountOccupancyLimit());
            this.selectCreditAccountFlow(accountAmtFlowVO, accountAppParam);
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7c7b\u578b\u672a\u5339\u914d\u5230!");
        }
        return accountAmtFlowVO;
    }

    public void selectAccountFlow(AccountAmtFlowVO accountAmtFlowVO, AccountAppParam accountAppParam) {
        AccountFlowPageParam flowPageParam = new AccountFlowPageParam();
        flowPageParam.setCurrent(accountAppParam.getCurrent() + 1);
        flowPageParam.setSize(accountAppParam.getSize());
        flowPageParam.setKeyword(accountAppParam.getKeyword());
        flowPageParam.setAccountCode(accountAmtFlowVO.getAccountCode());
        flowPageParam.setAccountType(accountAppParam.getAccountType());
        flowPageParam.setFlowNo(accountAppParam.getFlowNo());
        flowPageParam.setTransactionTimeS(accountAppParam.getTransactionTimeS());
        flowPageParam.setTransactionTimeE(accountAppParam.getTransactionTimeE());
        flowPageParam.setAmountFrom(accountAppParam.getAmountFrom());
        flowPageParam.setAmountTo(accountAppParam.getAmountTo());
        flowPageParam.setTransactionTypeList(accountAppParam.getTransactionTypeList());
        flowPageParam.setSourceDocList(accountAppParam.getSourceDocList());
        flowPageParam.setSourceNo(accountAppParam.getSourceNo());
        flowPageParam.setOrders(accountAppParam.getOrders());
        flowPageParam.setCustomParam(accountAppParam.getCustomParam());
        flowPageParam.setConditions(accountAppParam.getConditions());
        flowPageParam.setBasicModuleCode(accountAppParam.getBasicModuleCode());
        flowPageParam.setBusinessObjectCode(accountAppParam.getBusinessObjectCode());
        flowPageParam.setAuditDateS(accountAppParam.getAuditDateS());
        flowPageParam.setAuditDateE(accountAppParam.getAuditDateE());
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowService.appPage(flowPageParam);
        List flowVOList = pagingVO.getRecords();
        if (CollectionUtils.isEmpty((Collection)flowVOList)) {
            accountAmtFlowVO.setFlowPagingVO((PagingVO<AccountFlowAppVO>)PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build());
        } else {
            List accountFlowAppVOList = flowVOList.stream().map(accountFlowVO -> {
                AccountFlowAppVO accountFlowAppVO = new AccountFlowAppVO();
                accountFlowAppVO.setId(accountFlowVO.getId());
                accountFlowAppVO.setFlowNo(accountFlowVO.getFlowNo());
                accountFlowAppVO.setAmount(accountFlowVO.getAmount());
                accountFlowAppVO.setTransactionType(accountFlowVO.getTransactionType());
                accountFlowAppVO.setTransactionTypeName(accountFlowVO.getTransactionTypeName());
                accountFlowAppVO.setTransactionTime(accountFlowVO.getTransactionTime());
                accountFlowAppVO.setSourceDoc(accountFlowVO.getSourceDoc());
                accountFlowAppVO.setSourceDocName(accountFlowVO.getSourceDocName());
                accountFlowAppVO.setSourceNo(accountFlowVO.getSourceNo());
                accountFlowAppVO.setAccountType(accountFlowVO.getAccountType());
                accountFlowAppVO.setAccountTypeName(accountFlowVO.getAccountTypeName());
                accountFlowAppVO.setAccountCode(accountFlowVO.getAccountCode());
                accountFlowAppVO.setAccountName(accountFlowVO.getAccountName());
                accountFlowAppVO.setAuditDate(accountFlowVO.getAuditDate());
                return accountFlowAppVO;
            }).collect(Collectors.toList());
            accountAmtFlowVO.setFlowPagingVO((PagingVO<AccountFlowAppVO>)PagingVO.builder().total(pagingVO.getTotal()).records(accountFlowAppVOList).build());
        }
    }

    public void selectCreditAccountFlow(AccountAmtFlowVO accountAmtFlowVO, AccountAppParam accountAppParam) {
        CreditAccountFlowPageParam flowPageParam = new CreditAccountFlowPageParam();
        flowPageParam.setCurrent(accountAppParam.getCurrent() + 1);
        flowPageParam.setSize(accountAppParam.getSize());
        flowPageParam.setKeyword(accountAppParam.getKeyword());
        flowPageParam.setCreditAccountCode(accountAmtFlowVO.getAccountCode());
        flowPageParam.setCreditAccountType(accountAppParam.getAccountType());
        flowPageParam.setFlowNo(accountAppParam.getFlowNo());
        flowPageParam.setTransactionTimeS(accountAppParam.getTransactionTimeS());
        flowPageParam.setTransactionTimeE(accountAppParam.getTransactionTimeE());
        flowPageParam.setAmountFrom(accountAppParam.getAmountFrom());
        flowPageParam.setAmountTo(accountAppParam.getAmountTo());
        flowPageParam.setTransactionTypeList(accountAppParam.getTransactionTypeList());
        flowPageParam.setSourceDocList(accountAppParam.getSourceDocList());
        flowPageParam.setSourceNo(accountAppParam.getSourceNo());
        flowPageParam.setOrders(accountAppParam.getOrders());
        flowPageParam.setCustomParam(accountAppParam.getCustomParam());
        flowPageParam.setConditions(accountAppParam.getConditions());
        flowPageParam.setBasicModuleCode(accountAppParam.getBasicModuleCode());
        flowPageParam.setBusinessObjectCode(accountAppParam.getBusinessObjectCode());
        flowPageParam.setAuditDateS(accountAppParam.getAuditDateS());
        flowPageParam.setAuditDateE(accountAppParam.getAuditDateE());
        PagingVO<CreditAccountFlowDTO> pagingVO = this.creditAccountFlowService.appPage(flowPageParam);
        List flowDTOList = pagingVO.getRecords();
        if (CollectionUtils.isEmpty((Collection)flowDTOList)) {
            accountAmtFlowVO.setFlowPagingVO((PagingVO<AccountFlowAppVO>)PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build());
        } else {
            List accountFlowAppVOList = flowDTOList.stream().map(accountFlowVO -> {
                AccountFlowAppVO accountFlowAppVO = new AccountFlowAppVO();
                accountFlowAppVO.setId(accountFlowVO.getId());
                accountFlowAppVO.setFlowNo(accountFlowVO.getFlowNo());
                accountFlowAppVO.setAmount(accountFlowVO.getAmount());
                accountFlowAppVO.setTransactionType(accountFlowVO.getTransactionType());
                accountFlowAppVO.setTransactionTypeName(accountFlowVO.getTransactionTypeName());
                accountFlowAppVO.setTransactionTime(accountFlowVO.getTransactionTime());
                accountFlowAppVO.setSourceDoc(accountFlowVO.getSourceDoc());
                accountFlowAppVO.setSourceDocName(accountFlowVO.getSourceDocName());
                accountFlowAppVO.setSourceNo(accountFlowVO.getSourceNo());
                accountFlowAppVO.setAccountType(accountFlowVO.getCreditAccountType());
                accountFlowAppVO.setAccountTypeName(accountFlowVO.getCreditAccountTypeName());
                accountFlowAppVO.setAccountCode(accountFlowVO.getCreditAccountCode());
                accountFlowAppVO.setAccountName(accountFlowVO.getCreditAccountName());
                accountFlowAppVO.setAuditDate(accountFlowVO.getAuditDate());
                return accountFlowAppVO;
            }).collect(Collectors.toList());
            accountAmtFlowVO.setFlowPagingVO((PagingVO<AccountFlowAppVO>)PagingVO.builder().total(pagingVO.getTotal()).records(accountFlowAppVOList).build());
        }
    }

    private void selectCustByStore(AccountAppParam accountAppParam) {
        if (StringUtils.isBlank((CharSequence)accountAppParam.getCustCode())) {
            accountAppParam.setStoreCode(accountAppParam.getStoreCode());
            StoreAccountCustAppVO accountCustAppVO = this.appAccountService.selectCheckCustByStore(accountAppParam);
            accountAppParam.setCustCode(accountCustAppVO.getStoreCustCode());
        }
    }

    public AccountServiceImpl(AccountRepoProc accountRepoProc, AccountRepo accountRepo, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, SystemRpcService systemRpcService, UdcProvider udcProvider, RmiSaleRpcService rmiSaleRpcService, AccountSnapshotRepoProc accountSnapshotRepoProc, AccountSnapshotRepo accountSnapshotRepo, FlexFieldUtilService flexFieldUtilService, CreditAccountRepoProc creditAccountRepoProc, AppAccountService appAccountService) {
        this.accountRepoProc = accountRepoProc;
        this.accountRepo = accountRepo;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.systemRpcService = systemRpcService;
        this.udcProvider = udcProvider;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.accountSnapshotRepoProc = accountSnapshotRepoProc;
        this.accountSnapshotRepo = accountSnapshotRepo;
        this.flexFieldUtilService = flexFieldUtilService;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.appAccountService = appAccountService;
    }
}

