package com.elitesland.fin.application.convert.invoice;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.fin.application.facade.vo.invoice.PaymentVoucherRespVO;
import com.elitesland.fin.application.facade.vo.invoice.PaymentVoucherSaveVO;
import com.elitesland.fin.dto.invoice.PaymentVoucherRespDTO;
import com.elitesland.fin.dto.invoice.PaymentVoucherSaveDTO;
import com.elitesland.fin.entity.invoice.PaymentVoucherDO;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @Author: ryan.xu
 * @since 2023/4/6
 */
@Mapper(config = BaseMapperConfig.class)
public interface PaymentVoucherConvert {

    PaymentVoucherConvert INSTANCE = Mappers.getMapper(PaymentVoucherConvert.class);

    PaymentVoucherDO saveVoToDO(PaymentVoucherSaveVO saveVO);

    PaymentVoucherRespVO doToRespVO(PaymentVoucherDO paymentVoucherDO);

    @Mapping(source = "id", target = "id", ignore = true)
    PaymentVoucherSaveVO respToSaveVO(PaymentVoucherRespVO respVO);

    PaymentVoucherSaveVO doToSaveVO(PaymentVoucherDO paymentVoucherDO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(PaymentVoucherSaveVO saveVO, @MappingTarget PaymentVoucherDO paymentVoucherDO);

    PaymentVoucherRespDTO respVO2DTO(PaymentVoucherRespVO respVO);

    PaymentVoucherSaveVO saveDTO2VO(PaymentVoucherSaveDTO saveDTO);

}
