package com.elitesland.fin.application.facade.param.account;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author sunxw
 * @description 账户储值后续请求
 * @Date 2023/5/25
 */
@Data
public class AccountStorageFollowReq {

    @ApiModelProperty("支付流水号")
    private String payOrderId;

    @ApiModelProperty("单据类型")
    private Integer receiptType;

    @ApiModelProperty("单据状态")
    private Integer receiptStatus;

    @ApiModelProperty("收款账户名称")
    private String accName;

    @ApiModelProperty("收款账号编码")
    private String accCode;

    private Long ouId;

    @ApiModelProperty("收款公司")
    private String ouName;

    @ApiModelProperty("汇款主体名称")
    private String remitter;

    @ApiModelProperty("汇款主体类型")
    private Integer remitterType;

    @ApiModelProperty("汇款账户名称")
    private String remitterName;

    @ApiModelProperty("汇款账号")
    private String remitterAccount;

    @ApiModelProperty("汇款/交易日期")
    private String remitterTime;

    @ApiModelProperty("支付方式")
    private Integer payMode;

    @ApiModelProperty("汇款/订单金额")
    private BigDecimal remitterAmt;

    @ApiModelProperty("原始交易日期")
    private String oriTranDate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("审核人")
    private String checker;

    @ApiModelProperty("审核时间")
    private String checkTime;

    @ApiModelProperty("审核拒绝理由")
    private String rejectReason;

    @ApiModelProperty("退款金额")
    private String refundAmt;

    @ApiModelProperty("退款摘要")
    private String abstractInfo;

    @ApiModelProperty("退款原始报文")
    private String oriMsg;

}
