package com.elitesland.fin.repo.account;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.entity.account.QTcStatementAccountDO;
import com.elitesland.fin.entity.account.TcStatementAccountDO;
import com.elitesland.fin.param.account.TcStatementAccountPageParam;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 天龙对账单仓储处理类
 *
 * @author elitesland
 */
@Component
@RequiredArgsConstructor
public class TcStatementAccountRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QTcStatementAccountDO qTcStatementAccountDO = QTcStatementAccountDO.tcStatementAccountDO;

    private final TcStatementAccountRepo tcStatementAccountRepo;

    /**
     * 分页查询天龙对账单
     *
     * @param pageParam 分页参数
     * @return 分页结果
     */
    public PagingVO<TcStatementAccountDO> page(TcStatementAccountPageParam pageParam) {
        JPAQuery<TcStatementAccountDO> query = buildJPAQuery(pageParam);
        // 数据权限
        BusinessSecurityUtil.where(query, TcStatementAccountDO.class);
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qTcStatementAccountDO);
        List<TcStatementAccountDO> fetch = query.fetch();

        return PagingVO.<TcStatementAccountDO>builder()
                .total(query.fetchCount())
                .records(fetch)
                .build();
    }

    /**
     * 构建查询条件
     *
     * @param pageParam 分页参数
     * @return JPA查询对象
     */
    public JPAQuery<TcStatementAccountDO> buildJPAQuery(TcStatementAccountPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();

        if (CollectionUtil.isNotEmpty(pageParam.getIds())) {
            predicates.add(qTcStatementAccountDO.id.in(pageParam.getIds()));
        }

        if (StringUtils.isNotBlank(pageParam.getReconciliationNo())) {
            predicates.add(qTcStatementAccountDO.reconciliationNo.like("%" + pageParam.getReconciliationNo() + "%"));
        }

        if (StringUtils.isNotBlank(pageParam.getStoreCode())) {
            predicates.add(qTcStatementAccountDO.storeCode.like("%" + pageParam.getStoreCode() + "%"));
        }

        if (StringUtils.isNotBlank(pageParam.getStoreName())) {
            predicates.add(qTcStatementAccountDO.storeName.like("%" + pageParam.getStoreName() + "%"));
        }

        if (StringUtils.isNotBlank(pageParam.getStoreBusinessType())) {
            predicates.add(qTcStatementAccountDO.storeBusinessType.eq(pageParam.getStoreBusinessType()));
        }

        if (pageParam.getReconciliationDateStart() != null) {
            predicates.add(qTcStatementAccountDO.reconciliationDate.goe(pageParam.getReconciliationDateStart()));
        }

        if (pageParam.getReconciliationDateEnd() != null) {
            predicates.add(qTcStatementAccountDO.reconciliationDate.loe(pageParam.getReconciliationDateEnd()));
        }

        if (StringUtils.isNotBlank(pageParam.getDraftStatus())) {
            predicates.add(qTcStatementAccountDO.draftStatus.eq(pageParam.getDraftStatus()));
        }

        if (StringUtils.isNotBlank(pageParam.getTransferStatus())) {
            predicates.add(qTcStatementAccountDO.transferStatus.eq(pageParam.getTransferStatus()));
        }

        if (StringUtils.isNotBlank(pageParam.getReconciliationType())) {
            predicates.add(qTcStatementAccountDO.reconciliationType.eq(pageParam.getReconciliationType()));
        }

        if (StringUtils.isNotBlank(pageParam.getReconciliationMode())) {
            predicates.add(qTcStatementAccountDO.reconciliationMode.eq(pageParam.getReconciliationMode()));
        }

        if (pageParam.getPartyATotalAmountMin() != null) {
            predicates.add(qTcStatementAccountDO.partyATotalAmount.goe(pageParam.getPartyATotalAmountMin()));
        }

        if (pageParam.getPartyATotalAmountMax() != null) {
            predicates.add(qTcStatementAccountDO.partyATotalAmount.loe(pageParam.getPartyATotalAmountMax()));
        }

        if (pageParam.getPartyBTotalAmountMin() != null) {
            predicates.add(qTcStatementAccountDO.partyBTotalAmount.goe(pageParam.getPartyBTotalAmountMin()));
        }

        if (pageParam.getPartyBTotalAmountMax() != null) {
            predicates.add(qTcStatementAccountDO.partyBTotalAmount.loe(pageParam.getPartyBTotalAmountMax()));
        }

        if (pageParam.getCreateTimeStart() != null) {
            predicates.add(qTcStatementAccountDO.createTime.goe(pageParam.getCreateTimeStart()));
        }

        if (pageParam.getCreateTimeEnd() != null) {
            predicates.add(qTcStatementAccountDO.createTime.loe(pageParam.getCreateTimeEnd()));
        }

        if (StringUtils.isNotBlank(pageParam.getWirteOffMark())){
            predicates.add(qTcStatementAccountDO.wirteOffMark.eq(pageParam.getWirteOffMark()));
        }
        if (StringUtils.isNotBlank(pageParam.getAccountBalancingMark())){
            predicates.add(qTcStatementAccountDO.accountBalancingMark.eq(pageParam.getAccountBalancingMark()));
        }



        // 增加扩展字段查询条件
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate(pageParam.getConditions(), TcStatementAccountDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
        }

        JPAQuery<TcStatementAccountDO> query = jpaQueryFactory.selectFrom(qTcStatementAccountDO)
                .where(ExpressionUtils.allOf(predicates));
        return query;
    }

    /**
     * 查询列表
     *
     * @param pageParam 查询参数
     * @return 天龙对账单列表
     */
    public List<TcStatementAccountDO> queryList(TcStatementAccountPageParam pageParam) {
        JPAQuery<TcStatementAccountDO> query = buildJPAQuery(pageParam);
        return query.fetch();
    }
}