/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DefaultRecOrderExportServiceImpl
implements DataExport<RecOrderEntity, RecOrderPageParam> {
    private final RecOrderDomainService recOrderDomainService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    public String getTmplCode() {
        return "FIN_REC_EXPORT_DEFAULT";
    }

    @SysCodeProc
    @BusinessObjectOperation(permissionRef="fin_rec_order_list", businessObjectType="Fin_Rec_Order:\u6536\u6b3e\u5355", operationType=OperationTypeEnum.EXPORT, operationDescription="\u6536\u6b3e\u5355\u9ed8\u8ba4\u5bfc\u51fa", operationCode="fin_rec_order_export_default", dataPermissionEnabled=true, fieldPermissionAutoFilter=true)
    public PagingVO<RecOrderEntity> executeExport(RecOrderPageParam queryParam) {
        if (queryParam.getReDateStart() == null || queryParam.getReDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u6536\u6b3e\u65e5\u671f!");
        }
        PagingVO<RecOrderEntity> recOrderDTOPagingVO = this.recOrderDomainService.exportRecOrder(queryParam);
        List records = recOrderDTOPagingVO.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return new PagingVO();
        }
        List<String> relOuCodes = records.stream().map(RecOrderEntity::getRelevanceOuCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relOuCodes);
        records.forEach(row -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(row.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                row.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return new PagingVO(recOrderDTOPagingVO.getTotal(), ExcelConvertUtils.convertLoosely(records, RecOrderEntity.class));
    }

    public Integer pageSize() {
        return 1000;
    }

    public DefaultRecOrderExportServiceImpl(RecOrderDomainService recOrderDomainService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.recOrderDomainService = recOrderDomainService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

