/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.saleinv;

import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.dto.mq.DemoMqMessageDTO;
import com.elitesland.fin.application.service.workflow.saleinv.SaleInvProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleInvProcessServiceImpl
implements SaleInvProcessService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final SaleInvRepoProc saleInvRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final MessageQueueTemplate messageQueueTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        SaleInvDTO saleInvDTO = this.saleInvRepoProc.get(id);
        if (saleInvDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QSaleInvDO saleInvDO = QSaleInvDO.saleInvDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)saleInvDO).set(saleInvDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{saleInvDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)saleInvDO.procInstId, (Object)null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(saleInvDO.approvedTime, (Object)LocalDateTime.now()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName()).set((Path)saleInvDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set(saleInvDO.approvedTime, (Object)LocalDateTime.now()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName());
                this.sendMessage(saleInvDTO);
                break;
            }
        }
        jpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        SaleInvDTO saleInvDTO = this.saleInvRepoProc.get(businessId);
        if (saleInvDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(saleInvDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    private void sendMessage(SaleInvDTO saleInvDTO) {
        DemoMqMessageDTO messageDTO = new DemoMqMessageDTO();
        messageDTO.setId(saleInvDTO.getId());
        messageDTO.setCode(saleInvDTO.getApplyNo());
        messageDTO.setInterfaceType("zt_to_nc_salinv");
        messageDTO.setDomainCode("yst-fin");
        this.messageQueueTemplate.publishMessage("yst-fin", "yst-fin", (Serializable)messageDTO);
    }

    public SaleInvProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, SaleInvRepoProc saleInvRepoProc, JPAQueryFactory jpaQueryFactory, MessageQueueTemplate messageQueueTemplate) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.saleInvRepoProc = saleInvRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.messageQueueTemplate = messageQueueTemplate;
    }
}

