package com.elitesland.fin.application.convert.expense;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpTypeParam;
import com.elitesland.fin.application.facade.vo.expense.ExpTypeVO;
import com.elitesland.fin.domain.expense.ExpType;
import com.elitesland.fin.domain.expense.ExpTypeDO;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package
 * @date 2022/4/11 13:45
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ExpTypeConvert {

    ExpTypeConvert INSTANCE = Mappers.getMapper(ExpTypeConvert.class);

    ExpType convert(ExpTypeParam expTypeParam);

    ExpTypeDO convert(ExpType expType);

    ExpTypeVO convert(ExpTypeDTO expTypeDTO);

    PagingVO<ExpTypeVO> convertPage(PagingVO<ExpTypeDTO> par);

    List<ExpTypeVO> convertList(List<ExpTypeDTO> expTypeDTOList);
}
