package com.elitesland.fin.application.facade.vo.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "付款通知单明细保存参数")
public class PaymentNoticeDSaveVO implements Serializable {

    @ApiModelProperty("付款通知单ID")
    private Long masId;

    @ApiModelProperty("收费项目")
    private String itemCode;

    @ApiModelProperty("收费项目名称")
    private String itemCodeName;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否参与开票")
    @SysCode(sys = "yst-fin",mod = "IS_BILLING")
    private String isToBilling;
    private String isToBillingName;

}
