package com.elitesland.fin.infr.repo.arverconfig;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.arverconfig.QArVerConfigDO;
import com.elitesland.fin.domain.param.arverconfig.ArVerConfigPageParam;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 14:43
 */
@Component
@RequiredArgsConstructor
public class ArVerConfigRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArVerConfigDO arVerConfigDO = QArVerConfigDO.arVerConfigDO;

    public ArVerConfigDTO queryById(Long id) {
        return select(ArVerConfigDTO.class)
                .where(arVerConfigDO.id.eq(id))
                .fetchOne();
    }

    public List<ArVerConfigDTO> queryByIds(List<Long> ids) {
        return select(ArVerConfigDTO.class)
                .where(arVerConfigDO.id.in(ids))
                .fetch();
    }

    public List<ArVerConfigDTO> queryAll() {
        return select(ArVerConfigDTO.class)
                .where(arVerConfigDO.enableFlag.isTrue())
                .fetch();
    }

    public ArVerConfigDTO queryDef() {
        return select(ArVerConfigDTO.class)
                .where(arVerConfigDO.enableFlag.isTrue())
                .where(arVerConfigDO.defaultFlag.isTrue())
                .where(arVerConfigDO.deleteFlag.eq(0))
                .fetchOne();
    }

    public Boolean existNameByName(String name) {
        return jpaQueryFactory.select(arVerConfigDO.id)
                .from(arVerConfigDO)
                .where(arVerConfigDO.schemeName.eq(name))
                .fetchCount() > 0;
    }

    public Boolean existNameById(String name, Long id) {
        return jpaQueryFactory.select(arVerConfigDO.id)
                .from(arVerConfigDO)
                .where(arVerConfigDO.schemeName.eq(name))
                .where(arVerConfigDO.id.notIn(id))
                .fetchCount() > 0;
    }


    public Long updateDefaultById(Long id, Boolean isDefault) {
        return jpaQueryFactory.update(arVerConfigDO)
                .set(arVerConfigDO.defaultFlag, isDefault)
                .where(arVerConfigDO.id.eq(id))
                .execute();
    }

    public void updateDefault() {
        jpaQueryFactory.update(arVerConfigDO)
                .set(arVerConfigDO.defaultFlag, false)
                .where(arVerConfigDO.defaultFlag.isTrue())
                .execute();
    }

    public void updateEnable(List<Long> ids,boolean state) {
        jpaQueryFactory.update(arVerConfigDO)
                .set(arVerConfigDO.enableFlag, state)
                .where(arVerConfigDO.id.in(ids))
                .execute();
    }

    public PagingVO<ArVerConfigDTO> page(ArVerConfigPageParam param) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();

        predicates.add(arVerConfigDO.deleteFlag.eq(0));
        JPAQuery<ArVerConfigDTO> query = select(ArVerConfigDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, arVerConfigDO);
        return PagingVO.<ArVerConfigDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public Boolean isFirst() {
        return jpaQueryFactory.select(arVerConfigDO.id)
                .from(arVerConfigDO)
                .where(arVerConfigDO.deleteFlag.eq(0))
                .fetchCount() > 0;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                arVerConfigDO.id,
                arVerConfigDO.enableFlag,
                arVerConfigDO.schemeName,
                arVerConfigDO.schemeNo,
                arVerConfigDO.defaultFlag,
                arVerConfigDO.remark,
                arVerConfigDO.createTime,
                arVerConfigDO.creator,
                arVerConfigDO.createUserId,
                arVerConfigDO.modifyTime,
                arVerConfigDO.modifyUserId,
                arVerConfigDO.updater,
                arVerConfigDO.writeoffOrder,
                arVerConfigDO.redOffsetFlag)
        ).from(arVerConfigDO);
    }
}
