package com.elitesland.fin.provider.accountingengine;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookConvert;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookLineConvert;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.dto.accountingengine.FinSetOfBookLineRpcDTO;
import com.elitesland.fin.dto.accountingengine.FinSetOfBookRpcDTO;
import com.elitesland.fin.param.accountingengine.FinSetOfBookSyncParam;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.service.accountingengine.FinSetOfBookRpcService;
import com.elitesland.fin.service.accountingengine.JournalGenerateRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + FinSetOfBookRpcService.PATH)
@Slf4j
public class FinSetOfBookRpcServiceImpl implements FinSetOfBookRpcService {

    private final FinSetOfBookRepo finSettOfBookRepo;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;

    @Override
    public ApiResult<FinSetOfBookRpcDTO> findSetOfBookByCode(String sobCode) {
        List<FinSetOfBookDO> allBySobCode = finSettOfBookRepo.findAllBySobCode(sobCode);
        if(CollectionUtils.isEmpty(allBySobCode)){
            return ApiResult.fail(sobCode + "不存在");
        }
        FinSetOfBookRpcDTO finSetOfBookRpcDTO = FinSetOfBookConvert.INSTANCE.doToRpcDTO(allBySobCode.get(0));

        List<FinSetOfBookLineDO> lineDOS = finSetOfBookLineRepo.findAllByMasId(finSetOfBookRpcDTO.getId());
        List<FinSetOfBookLineRpcDTO> lineList = FinSetOfBookLineConvert.INSTANCE.doToRpcDto(lineDOS);
        finSetOfBookRpcDTO.setDimenDetailList(lineList);
        return ApiResult.ok(finSetOfBookRpcDTO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Void> updateSyncStatus(List<FinSetOfBookSyncParam> param) {
        log.info("科目表同步状态回写, 时间：{}，入参：{}", LocalDateTime.now(), JSONObject.toJSONString(param));
        for (FinSetOfBookSyncParam paramVO : param) {
            finSetOfBookRepoProc.updateSyncStatus(paramVO);
        }
        return ApiResult.ok();
    }
}
