/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.unionpay.impl;

import com.chinapay.secss.SecssUtil;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.account.AccountStorageFollowReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageQueryReq;
import com.elitesland.fin.application.service.unionpay.UnionPayService;
import com.elitesland.fin.application.service.unionpay.config.UnionPaySecssUtil;
import com.elitesland.fin.application.service.unionpay.entity.enums.ReceiptStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.RespCodeEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.SourceTypeEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.StoredOrderTypeEnum;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.application.service.unionpay.util.UnionPayUtil;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.entity.account.AccountStorageDetailDO;
import com.elitesland.fin.infinity.http.RestClient;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepo;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.repo.account.AccountStorageDetailRepo;
import com.elitesland.fin.repo.account.AccountStorageRepo;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import com.elitesland.fin.utils.TimeUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UnionPayServiceImpl
implements UnionPayService {
    private static final Logger log = LoggerFactory.getLogger(UnionPayServiceImpl.class);
    @Value(value="${china.pay.merId}")
    private String merId;
    @Value(value="${china.pay.refundUrl}")
    private String refundUrl;
    @Value(value="${china.pay.queryUrl}")
    private String queryUrl;
    @Value(value="${china.baseBack.pay}")
    private String backPayUrl;
    @Value(value="${china.baseBack.refund}")
    private String backRefundUrl;
    @Value(value="${china.pay.remoteAddr}")
    private String remoteAddr;
    @Autowired
    private AccountStorageRepo accountStorageRepo;
    @Autowired
    private RecOrderRpcFiledRepo recOrderRpcFiledRepo;
    @Autowired
    private AccountStorageDetailRepo accountStorageDetailRepo;
    private final AccountFlowRpcService accountFlowRpcService;
    private final RestClient restClient;
    @Autowired
    private SecssUtil secssUtil;
    @Autowired
    private UnionPaySecssUtil unionPaySecssUtil;
    private final TenantProvider tenantProvider;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private static final Random RANDOM = new Random();

    @Override
    @Transactional
    public Map<String, Object> sendPay(SendPayReq payReq) {
        String receiptStatus = this.accountStorageRepo.getReceiptStatusByOrderId(payReq.getPayOrderId());
        if (!ReceiptStatusEnum.PENDING_PAY.getCode().equals(receiptStatus)) {
            log.error("\u5f53\u524d\u50a8\u503c\u5355\u5355\u636e\u72b6\u6001\u975e\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u652f\u4ed8\uff0c\u5355\u636e\u6d41\u6c34\u53f7\u4e3a:[{}]", (Object)payReq.getPayOrderId());
            throw new BusinessException("\u5f53\u524d\u50a8\u503c\u5355\u5355\u636e\u72b6\u6001\u975e\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u65e0\u6cd5\u91cd\u590d\u53d1\u8d77\u652f\u4ed8\uff0c\u5355\u636e\u6d41\u6c34\u53f7\u4e3a:" + payReq.getPayOrderId());
        }
        TreeMap<String, Object> data = this.buildPayParams(payReq);
        log.info("4.1\u652f\u4ed8\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u4e3a :{}", data);
        AccountStorageDO storageDO = new AccountStorageDO();
        storageDO.setId(payReq.getStorageId());
        storageDO.setReceiptStatus(payReq.getReceiptStatus());
        this.accountStorageRepo.updateReceiptStatus(payReq.getPayOrderId(), payReq.getReceiptStatus());
        this.recOrderRpcFiledRepo.updateReceiptStatus(payReq.getPayOrderId(), payReq.getReceiptStatus());
        return data;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void payCallBack(Map<String, String> data) {
        String merOrderNo = data.get("MerOrderNo");
        log.info("\u50a8\u503c\u8ba2\u5355\u53f7[{}]\u64cd\u4f5c\u6210\u529f", (Object)merOrderNo);
        AccountStorageQueryReq queryReq = new AccountStorageQueryReq();
        queryReq.setOriTranDate(data.get("TranDate"));
        queryReq.setPayOrderId(merOrderNo);
        String queryPayResult = this.queryPay(queryReq);
        if (StringUtils.isNotEmpty((CharSequence)queryPayResult)) {
            String receiptStatus;
            String result = queryPayResult.replaceAll("amp;", "");
            HashMap<String, String> queryResult = UnionPayUtil.form2Map(result);
            RecOrderRpcTwoParam recOrderRpcTwoParam = new RecOrderRpcTwoParam();
            recOrderRpcTwoParam.setSourceNo(merOrderNo);
            String remitterAccount = this.recOrderRpcFiledRepo.getAccountByOrderId(merOrderNo);
            if ("0000".equals(data.get("OrderStatus")) && "0000".equals(queryResult.get("OrderStatus"))) {
                receiptStatus = ReceiptStatusEnum.PAY_SUCCESS.getCode();
                Long storageId = this.accountStorageRepo.getIdByOrderId(merOrderNo);
                this.generateAccountFlow(receiptStatus, data.get("OrderAmt"), storageId, null);
                if (StringUtils.isNotEmpty((CharSequence)data.get("CardTranData"))) {
                    String accountData = this.unionPaySecssUtil.getDecData(data.get("CardTranData"));
                    log.info("4.1\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u8d26\u6237\u4fe1\u606fis {}", (Object)accountData);
                    if (!remitterAccount.equals(accountData)) {
                        AccountStorageFollowReq followReq = new AccountStorageFollowReq();
                        followReq.setPayOrderId(merOrderNo);
                        followReq.setRefundAmt(data.get("OrderAmt"));
                        followReq.setOriTranDate(data.get("TranDate"));
                        this.followPay(followReq);
                    }
                }
            } else {
                receiptStatus = ReceiptStatusEnum.PAY_FAILED.getCode();
            }
            this.accountStorageRepo.updateReceiptStatus(merOrderNo, receiptStatus);
            this.recOrderRpcFiledRepo.updateReceiptStatus(merOrderNo, receiptStatus);
            this.accountStorageRepo.updateMsg(merOrderNo, data.toString(), RespCodeEnum.find(data.get("OrderStatus")));
        }
    }

    @Override
    @Transactional
    public String followPay(AccountStorageFollowReq req) {
        TreeMap<String, Object> data = this.buildFollowPayParams(req);
        String result = this.restClient.postFormData(this.refundUrl, data);
        log.info("4.15\u4ea4\u6613\u540e\u7eed\u540c\u6b65\u54cd\u5e94\u4fe1\u606f\u4e3a :{}", (Object)result);
        AccountStorageDetailDO accountStorageDetailDO = new AccountStorageDetailDO();
        accountStorageDetailDO.setRefundOrderId((String)data.get("MerOrderNo"));
        Long storageId = this.accountStorageRepo.getIdByOrderId(req.getPayOrderId());
        accountStorageDetailDO.setStorageId(storageId);
        accountStorageDetailDO.setRemitterDate(TimeUtil.string2Date(req.getOriTranDate()));
        accountStorageDetailDO.setOriMsg(req.getOriMsg());
        accountStorageDetailDO.setRefundDate(LocalDate.now());
        accountStorageDetailDO.setRefundReason("\u5b9e\u9645\u6c47\u6b3e\u94f6\u884c\u8d26\u6237\u4e0e\u5f00\u7968\u4e3b\u4f53\u8d26\u6237\u4fe1\u606f\u4e0d\u4e00\u81f4");
        BigDecimal refundAmt = new BigDecimal(req.getRefundAmt()).divide(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
        accountStorageDetailDO.setRefundAmt(refundAmt);
        this.accountStorageDetailRepo.save((Object)accountStorageDetailDO);
        this.accountStorageRepo.updateReceiptStatus(req.getPayOrderId(), ReceiptStatusEnum.REFUNDING.getCode());
        this.recOrderRpcFiledRepo.updateReceiptStatus(req.getPayOrderId(), ReceiptStatusEnum.REFUNDING.getCode());
        return result;
    }

    @Override
    @Transactional
    public void followPayCallback(Map<String, String> data) {
        AccountStorageQueryReq queryReq = new AccountStorageQueryReq();
        queryReq.setOriTranDate(TimeUtil.date2String(LocalDate.now()));
        queryReq.setPayOrderId(data.get("OriOrderNo"));
        String queryPayResult = this.queryPay(queryReq);
        String result = queryPayResult.replaceAll("amp;", "");
        HashMap<String, String> queryResult = UnionPayUtil.form2Map(result);
        if (StringUtils.isNotEmpty((CharSequence)queryPayResult)) {
            String receiptStatus;
            Long storageId = this.accountStorageRepo.getIdByOrderId(data.get("OriOrderNo"));
            String oriPayOrderId = data.get("OriOrderNo");
            if ("0000".equals(data.get("OrderStatus")) && "0000".equals(queryResult.get("OrderStatus"))) {
                receiptStatus = ReceiptStatusEnum.REFUND_SUCCESS.getCode();
                Long refundId = this.accountStorageDetailRepo.selectIdByRefundId(data.get("MerOrderNo"));
                this.generateAccountFlow(receiptStatus, data.get("RefundAmt"), storageId, refundId);
            } else {
                receiptStatus = ReceiptStatusEnum.REFUND_FAILED.getCode();
            }
            this.accountStorageRepo.updateReceiptStatus(oriPayOrderId, receiptStatus);
            this.recOrderRpcFiledRepo.updateReceiptStatus(oriPayOrderId, receiptStatus);
            this.accountStorageDetailRepo.updateOriMsg(storageId, data.toString());
        }
    }

    @Override
    public String queryPay(AccountStorageQueryReq req) {
        TreeMap<String, Object> data = this.buildQueryPayParams(req);
        String result = this.restClient.postFormData(this.queryUrl, data);
        log.info("4.16\u4ea4\u6613\u67e5\u8be2\u54cd\u5e94\u4fe1\u606f\u4e3a :{}", (Object)result);
        return result;
    }

    private TreeMap<String, Object> buildPayParams(SendPayReq payReq) {
        TreeMap<String, Object> req = new TreeMap<String, Object>();
        req.put("Version", "20140728");
        req.put("MerId", this.merId);
        req.put("MerOrderNo", payReq.getPayOrderId());
        req.put("TranDate", TimeUtil.date2String(LocalDate.now()));
        req.put("TranTime", TimeUtil.time2String(LocalTime.now()));
        Long orderAmt = payReq.getRemitterAmt().multiply(new BigDecimal(100)).longValue();
        req.put("OrderAmt", orderAmt.toString());
        req.put("BusiType", "0001");
        req.put("BankInstNo", payReq.getRemitterBankCode());
        req.put("TranType", "0002");
        req.put("MerBgUrl", this.backPayUrl);
        if (StringUtils.isNotEmpty((CharSequence)payReq.getMerPageUrl())) {
            req.put("MerPageUrl", payReq.getMerPageUrl());
        }
        req.put("RemoteAddr", this.remoteAddr);
        this.secssUtil.sign(req);
        log.info("\u652f\u4ed8\u4ea4\u6613\u7b7e\u540d\u54cd\u5e94is {}\uff0c\u4fe1\u606f {}", (Object)this.secssUtil.getErrCode(), (Object)this.secssUtil.getErrMsg());
        String sign = this.secssUtil.getSign();
        req.put("Signature", sign);
        return req;
    }

    private TreeMap<String, Object> buildFollowPayParams(AccountStorageFollowReq param) {
        String prefix = TimeUtil.datetime2String(LocalDateTime.now());
        Integer suffix = RANDOM.nextInt(99999);
        StringBuilder refundOrderId = new StringBuilder(prefix);
        refundOrderId.append(suffix);
        TreeMap<String, Object> req = new TreeMap<String, Object>();
        req.put("Version", "20140728");
        req.put("MerId", this.merId);
        req.put("MerOrderNo", refundOrderId.toString());
        req.put("TranDate", TimeUtil.date2String(LocalDate.now()));
        req.put("TranTime", TimeUtil.time2String(LocalTime.now()));
        req.put("RefundAmt", param.getRefundAmt());
        req.put("OriOrderNo", param.getPayOrderId());
        req.put("OriTranDate", param.getOriTranDate());
        req.put("TranType", "0401");
        req.put("BusiType", "0001");
        req.put("MerBgUrl", this.backRefundUrl);
        this.secssUtil.sign(req);
        log.info("\u540e\u7eed\u4ea4\u6613\u7b7e\u540d\u54cd\u5e94is {}\uff0c\u4fe1\u606f {}", (Object)this.secssUtil.getErrCode(), (Object)this.secssUtil.getErrMsg());
        String sign = this.secssUtil.getSign();
        req.put("Signature", sign);
        return req;
    }

    private TreeMap<String, Object> buildQueryPayParams(AccountStorageQueryReq param) {
        TreeMap<String, Object> req = new TreeMap<String, Object>();
        req.put("Version", "20140728");
        req.put("MerId", this.merId);
        req.put("MerOrderNo", param.getPayOrderId());
        req.put("TranDate", param.getOriTranDate());
        req.put("TranType", "0502");
        req.put("BusiType", "0001");
        this.secssUtil.sign(req);
        log.info("\u5546\u52a1\u4ea4\u6613\u7b7e\u540d\u54cd\u5e94is {}\uff0c\u4fe1\u606f {}", (Object)this.secssUtil.getErrCode(), (Object)this.secssUtil.getErrMsg());
        String sign = this.secssUtil.getSign();
        req.put("Signature", sign);
        return req;
    }

    private void generateAccountFlow(String sourceDocStatus, String sourceDocAmount, Long storageId, Long key) {
        BigDecimal sourceAmt = new BigDecimal(sourceDocAmount).divide(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
        String remitter = this.accountStorageRepo.getRemitterIdByKey(storageId);
        AccountFlowRpcParam rpcParam = new AccountFlowRpcParam();
        if (ObjectUtils.isNotEmpty((Object)key)) {
            rpcParam.setSourceId(key);
        } else {
            rpcParam.setSourceId(storageId);
        }
        rpcParam.setSourceDoc(SourceTypeEnum.SVO.getCode());
        rpcParam.setSourceDocType(StoredOrderTypeEnum.PREPAY.getCode());
        rpcParam.setSourceDocStatus(sourceDocStatus);
        rpcParam.setSourceDocAmount(sourceAmt);
        rpcParam.setSourceNo(storageId.toString());
        rpcParam.setAccountHolderName(remitter);
        try {
            ApiResult apiResult = this.accountFlowRpcService.generateAccountFlow(rpcParam);
            log.info("\u50a8\u503c\u8ba2\u5355\u8d26\u6237\u6d41\u6c34 req is {},resp is{}", (Object)rpcParam, (Object)apiResult);
        }
        catch (Exception e) {
            log.error("\u50a8\u503c\u8ba2\u5355\u8c03\u7528\u8d26\u6237\u6d41\u6c34\u903b\u8f91\u53d1\u751f\u9519\u8bef\uff0creq is {}\uff0c\u9519\u8bef\u4fe1\u606f is :{}", (Object)rpcParam, (Object)e);
        }
    }

    public UnionPayServiceImpl(AccountFlowRpcService accountFlowRpcService, RestClient restClient, TenantProvider tenantProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.accountFlowRpcService = accountFlowRpcService;
        this.restClient = restClient;
        this.tenantProvider = tenantProvider;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }
}

