package com.elitesland.fin.application.facade.param.account;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.dto.account.AccountRuleConfigDtlDTO;
import com.elitesland.fin.common.WhetherEnum;
import com.elitesland.fin.utils.FinStringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.val;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@ApiModel(description = "账户规则传输类")
@Data
public class AccountRuleConfigSaveParam extends BaseModelParam implements Serializable {

    private static final long serialVersionUID = -9172927634362072762L;

    @ApiModelProperty("账户规则码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty("适用单据")
    private String optDoc;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    private String status;

    public List<AccountRuleConfigDtlDTO> accountRuleConfigDtlDTOList;

}
