package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.account.AccountBalanceParam;
import com.elitesland.fin.application.facade.vo.account.AccountBalanceVO;
import com.elitesland.fin.application.service.account.AccountBalanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/12/27
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/account/balance")
@RequiredArgsConstructor
@Api(value = "标准账户余额", tags = {"标准账户余额"})
public class AccountBalanceController {

    private final AccountBalanceService accountBalanceService;

    @ApiOperation("查询标准账户余额")
    @PostMapping("/selectAccountBalanceByParam")
    public ApiResult<List<AccountBalanceVO>> selectAccountBalanceByParam(@RequestBody AccountBalanceParam param) {
        return ApiResult.ok(accountBalanceService.selectAccountBalanceByParam(param));
    }
}
