package com.elitesland.fin.application.web.account;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.account.TcStatementAccountVO;
import com.elitesland.fin.application.service.account.TcStatementAccountService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.entity.account.TcStatementAccountDO;
import com.elitesland.fin.param.account.TcStatementAccountPageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;

/**
 * 天龙对账单控制器
 *
 * @author elitesland
 */
@RestController
@RequestMapping("/account/tcStatement")
@Api(tags = "天龙对账单管理")
@BusinessObject(businessType = FinBusinessObjectConstant.TC_STATEMENT_ACCOUNT, businessDoClass = TcStatementAccountDO.class)
public class TcStatementAccountController {

    @Autowired
    private TcStatementAccountService tcStatementAccountService;



    @PostMapping("page")
    @ApiOperation("获取所有天龙对账单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "获取所有天龙对账单",
            businessObjectType = FinBusinessObjectConstant.TC_STATEMENT_ACCOUNT, operationCode = "LIST_STATEMENT_ACCOUNT")
    public ApiResult<PagingVO<TcStatementAccountVO>> page(TcStatementAccountPageParam pageParam) {
        PagingVO<TcStatementAccountVO> result = tcStatementAccountService.page(pageParam);
        return ApiResult.ok(result);
    }

    @PostMapping("/sync")
    @ApiOperation("同步天龙对账单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DOWNLOAD, operationDescription = "同步天龙对账单",
            businessObjectType = FinBusinessObjectConstant.TC_STATEMENT_ACCOUNT, operationCode = "SYNC_STATEMENT_ACCOUNT")
    public ApiResult<Void> sync(@RequestParam(required = false) String fileName) throws IOException {
        tcStatementAccountService.sync(fileName);
        return ApiResult.ok();
    }


}