package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAbstractParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAbstractVO;
import com.elitesland.fin.application.service.accountingengine.FinAbstractService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/account/abstract")
@RequiredArgsConstructor
@Api(value = "组合设置", tags = {"组合设置"})
public class FinAbstractController {

    private final FinAbstractService finAbstractService;

    @PostMapping("saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinAbstractParam param) {
        try {
            return ApiResult.ok(finAbstractService.saveOrUpdate(param));
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinAbstractVO>> page(@RequestBody FinAbstractParam param) {
        try {
            return ApiResult.ok(finAbstractService.page(param));
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("delete")
    @ApiOperation("删除")
    public ApiResult<Long> delete(@RequestBody FinAbstractParam param) {
        try {
            finAbstractService.delete(param);
            return ApiResult.ok();
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("updateStatus")
    @ApiOperation("启用停用")
    public ApiResult<Long> updateStatus(@RequestBody FinAbstractParam param) {
        try {
            finAbstractService.updateStatus(param);
            return ApiResult.ok();
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }


}
