/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.expense;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.expense.QExpTypeDO;
import com.elitesland.fin.domain.expense.QExpTypeDtlDO;
import com.elitesland.fin.domain.param.expense.ExpTypePageParam;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ExpTypeRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QExpTypeDO qExpTypeDO = QExpTypeDO.expTypeDO;
    private final QExpTypeDtlDO qExpTypeDtlDO = QExpTypeDtlDO.expTypeDtlDO;

    public <T> JPAQuery<T> select(Class<T> T) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(T, (Expression[])new Expression[]{this.qExpTypeDO.id, this.qExpTypeDO.itemCode, this.qExpTypeDO.itemName, this.qExpTypeDO.expTypeCode, this.qExpTypeDO.expTypeName, this.qExpTypeDO.enableFlag, this.qExpTypeDO.sourceDoc, this.qExpTypeDO.sourceDocType, this.qExpTypeDO.sourceDocStatus, this.qExpTypeDO.remark, this.qExpTypeDO.deleteFlag, this.qExpTypeDO.createTime, this.qExpTypeDO.creator, this.qExpTypeDO.createUserId, this.qExpTypeDO.modifyTime, this.qExpTypeDO.modifyUserId, this.qExpTypeDO.updater})).from((EntityPath)this.qExpTypeDO);
    }

    public Boolean existsName(String expTypeName) {
        long res = ((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.expTypeName.like("%" + expTypeName + "%"))).fetchCount();
        return res > 0L;
    }

    public Boolean existsCode(String expTypeCode) {
        long res = ((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.expTypeCode.like("%" + expTypeCode + "%"))).fetchCount();
        return res > 0L;
    }

    public ExpTypeDTO get(Long id) {
        return (ExpTypeDTO)((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.id.eq((Object)id))).fetchOne();
    }

    public ExpTypeDTO getByExpTypeCode(String expTypeCode) {
        return (ExpTypeDTO)((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.expTypeCode.eq((Object)expTypeCode))).fetchOne();
    }

    public List<ExpTypeDTO> getListByExpTypeCodes(List<String> expTypeCodes) {
        return ((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.expTypeCode.in(expTypeCodes))).fetch();
    }

    public PagingVO<ExpTypeDTO> page(ExpTypePageParam expTypePageParam, List<Long> exptypeIds) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CharSequenceUtil.isNotBlank((CharSequence)expTypePageParam.getExpTypeName())) {
            predicates.add(this.qExpTypeDO.expTypeName.like("%" + expTypePageParam.getExpTypeName() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)expTypePageParam.getExpTypeCode())) {
            predicates.add(this.qExpTypeDO.expTypeCode.like("%" + expTypePageParam.getExpTypeCode() + "%"));
        }
        if (expTypePageParam.getEnableFlag() != null) {
            predicates.add(this.qExpTypeDO.enableFlag.eq(expTypePageParam.getEnableFlag()));
        }
        if (null != expTypePageParam.getOuId()) {
            if (CollUtil.isNotEmpty(exptypeIds)) {
                predicates.add(this.qExpTypeDO.id.in(exptypeIds));
            } else {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty(expTypePageParam.getIdList())) {
            predicates.add(this.qExpTypeDO.id.in(expTypePageParam.getIdList()));
        }
        predicates.add(this.qExpTypeDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(ExpTypeDTO.class).where(ExpressionUtils.allOf(predicates));
        expTypePageParam.setPaging(query);
        expTypePageParam.fillOrders(query, this.qExpTypeDO);
        return new PagingVO(query.fetchCount(), query.fetch());
    }

    public List<ExpTypeDTO> findByIds(List<Long> ids) {
        return ((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.id.in(ids))).fetch();
    }

    public void updateEnableFlag(List<Long> ids, boolean enable) {
        this.jpaQueryFactory.update((EntityPath)this.qExpTypeDO).set((Path)this.qExpTypeDO.enableFlag, (Object)enable).where(new Predicate[]{this.qExpTypeDO.id.in(ids)}).execute();
    }

    public Boolean isFir() {
        long res = ((JPAQuery)this.jpaQueryFactory.select(this.qExpTypeDO.id).from((EntityPath)this.qExpTypeDO)).fetchCount();
        return res == 0L;
    }

    public ExpTypeDTO findById(Long id) {
        return (ExpTypeDTO)((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.id.eq((Object)id))).fetchOne();
    }

    public ExpTypeDTO findByExpTypeCode(String expTypeCode) {
        return (ExpTypeDTO)((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.expTypeCode.eq((Object)expTypeCode).and((Predicate)this.qExpTypeDO.enableFlag.eq(Boolean.valueOf(true))))).fetchOne();
    }

    public Long del(Long id) {
        return this.jpaQueryFactory.delete((EntityPath)this.qExpTypeDO).where(new Predicate[]{this.qExpTypeDO.id.eq((Object)id)}).execute();
    }

    public List<ExpTypeDTO> getList() {
        return ((JPAQuery)((JPAQuery)this.select(ExpTypeDTO.class).where((Predicate)this.qExpTypeDO.deleteFlag.eq((Object)0))).where((Predicate)this.qExpTypeDO.enableFlag.eq(Boolean.valueOf(true)))).fetch();
    }

    public List<ExpTypeDTO> arOrderAutoSelectMatchByParam(ExpTypePageParam expTypePageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CharSequenceUtil.isNotBlank((CharSequence)expTypePageParam.getSourceDoc())) {
            predicates.add(this.qExpTypeDtlDO.sourceDoc.eq((Object)expTypePageParam.getSourceDoc()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)expTypePageParam.getSourceDocType())) {
            predicates.add(this.qExpTypeDtlDO.sourceDocType.eq((Object)expTypePageParam.getSourceDocType()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)expTypePageParam.getSourceDocStatus())) {
            predicates.add(this.qExpTypeDtlDO.sourceDocStatus.eq((Object)expTypePageParam.getSourceDocStatus()));
        }
        predicates.add(this.qExpTypeDO.enableFlag.eq(Boolean.valueOf(true)));
        predicates.add(this.qExpTypeDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ExpTypeDTO.class, (Expression[])new Expression[]{this.qExpTypeDO.id, this.qExpTypeDO.expTypeCode, this.qExpTypeDO.expTypeName, this.qExpTypeDO.enableFlag, this.qExpTypeDO.createTime})).from((EntityPath)this.qExpTypeDO)).leftJoin((EntityPath)this.qExpTypeDtlDO)).on((Predicate)this.qExpTypeDO.id.eq(this.qExpTypeDtlDO.masId))).where(ExpressionUtils.allOf(predicates))).groupBy(this.qExpTypeDO.id);
        return query.fetch();
    }

    public ExpTypeRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

