/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.accountingengine;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableConvert;
import com.elitesland.fin.application.convert.accountingengine.FinJournalConvert;
import com.elitesland.fin.application.convert.accountingengine.FinJournalGenerateConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinEventTableDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinJournalDTO;
import com.elitesland.fin.application.facade.param.accountingengine.ManualProposedParam;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineJdbcService;
import com.elitesland.fin.application.service.accountingengine.JournalGenerateService;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.domain.entity.accountingengine.FinJournalDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.dto.accountingengine.FinFlexibleValueCheckItemRpcDTO;
import com.elitesland.fin.dto.accountingengine.FinJournalRpcDTO;
import com.elitesland.fin.param.accountingengine.FinJournalRpcParam;
import com.elitesland.fin.param.accountingengine.FinJournalSyncRpcParam;
import com.elitesland.fin.param.accountingengine.ManualProposedRpcParam;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineDetailsRepoProc;
import com.elitesland.fin.repo.accountingengine.FinEventTableRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.service.accountingengine.JournalGenerateRpcService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/manualProposed"})
public class JournalGenerateRpcServiceImpl
implements JournalGenerateRpcService {
    private static final Logger log = LoggerFactory.getLogger(JournalGenerateRpcServiceImpl.class);
    private final JournalGenerateService journalGenerateService;
    private final FinJournalRepoProc finJournalRepoProc;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinJournalRepo finJournalRepo;
    private final FinEventTableRepoProc finEventTableRepoProc;
    private final FinAccountEngineJdbcService finAccountEngineJdbcService;
    private final FinAccountEngineDetailsRepoProc finAccountEngineDetailsRepoProc;

    public ApiResult<Void> manualProposed(ManualProposedRpcParam rpcParam) {
        log.info("\u624b\u52a8\u62df\u5b9a\u7684Rpc\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)rpcParam));
        if (Objects.isNull(rpcParam)) {
            return ApiResult.ok();
        }
        ManualProposedParam manualProposedParam = FinJournalGenerateConvert.INSTANCE.rpcParamToParam(rpcParam);
        this.journalGenerateService.manualProposed(manualProposedParam);
        return ApiResult.ok();
    }

    @SysCodeProc
    public ApiResult<List<FinJournalRpcDTO>> findWaitSyncJournal(FinJournalRpcParam param) {
        List<FinJournalDTO> journalDTOList = this.finJournalRepoProc.findWaitSyncJournal(param);
        if (CollectionUtils.isEmpty(journalDTOList)) {
            return ApiResult.ok(new ArrayList());
        }
        List<FinJournalRpcDTO> rpcDTOList = FinJournalConvert.INSTANCE.DTOToRpc(journalDTOList);
        List<String> segment2List = rpcDTOList.stream().map(FinJournalRpcDTO::getSegment2).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(segment2List)) {
            Map<String, FinFlexibleValueDO> flexibleMap = this.finFlexibleValueRepo.findByFlexibleValueCodeIn(segment2List).stream().collect(Collectors.toMap(FinFlexibleValueDO::getFlexibleValueCode, t -> t));
            List<FinSetOfBookDO> bookDOList = this.finSetOfBookRepo.findAllBySobCode("NXG01");
            if (CollectionUtils.isEmpty(bookDOList)) {
                return ApiResult.fail((String)"\u8d26\u7c3fNXG01\u4e0d\u5b58\u5728");
            }
            Map<String, FinSetOfBookLineDO> lineMap = this.finSetOfBookLineRepo.findAllByMasId(bookDOList.get(0).getId()).stream().collect(Collectors.toMap(FinSetOfBookLineDO::getAccountDimenCode, t -> t));
            for (FinJournalRpcDTO rpcDTO : rpcDTOList) {
                if (!StringUtils.isNotEmpty((CharSequence)rpcDTO.getSegment2())) continue;
                Map map = BeanUtil.beanToMap((Object)rpcDTO, (String[])new String[0]);
                if (!flexibleMap.containsKey(rpcDTO.getSegment2())) {
                    return ApiResult.fail((String)("\u79d1\u76ee" + rpcDTO.getSegment2() + "\u4e0d\u5b58\u5728"));
                }
                FinFlexibleValueDO valueDO = flexibleMap.get(rpcDTO.getSegment2());
                if (!StringUtils.isNotEmpty((CharSequence)valueDO.getCheckitementry())) continue;
                List checkItemRpc = JSON.parseArray((String)valueDO.getCheckitementry(), FinFlexibleValueCheckItemRpcDTO.class);
                HashMap assgrp = new HashMap();
                for (FinFlexibleValueCheckItemRpcDTO checkItemRpcDTO : checkItemRpc) {
                    if (!lineMap.containsKey(checkItemRpcDTO.getAsstactitemNumber())) {
                        return ApiResult.fail((String)("\u6838\u7b97\u7ef4\u5ea6" + checkItemRpcDTO.getAsstactitemNumber() + "\u4e0d\u5b58\u5728"));
                    }
                    FinSetOfBookLineDO bookLineDO = lineMap.get(checkItemRpcDTO.getAsstactitemNumber());
                    HashMap<String, String> number = new HashMap<String, String>();
                    number.put("number", (String)(map.get(bookLineDO.getColumnName()) != null ? map.get(bookLineDO.getColumnName()) : ""));
                    assgrp.put(bookLineDO.getAccountDimenName(), number);
                }
                rpcDTO.setAssgrp(assgrp);
            }
        }
        return ApiResult.ok(rpcDTOList);
    }

    @Transactional
    public ApiResult<Void> updateSyncStatus(List<FinJournalSyncRpcParam> param) {
        log.info("\u51ed\u8bc1\u540c\u6b65\u72b6\u6001\u66f4\u65b0, \u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString(param));
        List<Long> idList = param.stream().map(FinJournalSyncRpcParam::getId).collect(Collectors.toList());
        List<FinJournalDO> journalDOS = this.finJournalRepo.findByIdIn(idList);
        List<Long> engineIdList = journalDOS.stream().map(FinJournalDO::getAccountEngineId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(engineIdList)) {
            return ApiResult.fail((String)"\u4f1a\u8ba1\u5f15\u64ceID\u4e0d\u5b58\u5728");
        }
        Map<Long, FinJournalDO> engineMap = journalDOS.stream().collect(Collectors.toMap(BaseModel::getId, t -> t));
        List<FinEventTableDTO> tableDOS = this.finEventTableRepoProc.findByEngineId(engineIdList);
        Map<Long, FinEventTableDTO> tableMap = tableDOS.stream().collect(Collectors.toMap(FinEventTableDTO::getEngineId, t -> t));
        Connection connection = null;
        try {
            connection = this.finAccountEngineJdbcService.getEventTableConnection(FinEventTableConvert.INSTANCE.DTOToDO(tableDOS.get(0)));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", (Object)tableDOS.get(0), (Object)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38");
        }
        try {
            for (FinJournalSyncRpcParam paramVO : param) {
                FinJournalDO finJournalDO;
                FinEventTableDTO tableDTO;
                if (engineMap.containsKey(paramVO.getId()) && (tableDTO = tableMap.get((finJournalDO = engineMap.get(paramVO.getId())).getAccountEngineId())) != null) {
                    try {
                        String updateProposedStatusSql = "update " + tableDTO.getDatabaseName() + "." + tableDTO.getMasTable() + " set transfer_status = '" + paramVO.getSyncStatus() + "' where " + tableDTO.getColumnDocNum() + " = '" + finJournalDO.getDocNum() + "'";
                        PreparedStatement preparedStatement = connection.prepareStatement(updateProposedStatusSql);
                        log.info("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001sql:\n{}", (Object)updateProposedStatusSql);
                        int res = preparedStatement.executeUpdate();
                        preparedStatement.close();
                    }
                    catch (SQLException e) {
                        log.error("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001\u5f02\u5e38, {}", (Throwable)e);
                        throw new BusinessException("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001\u5f02\u5e38\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                }
                this.finJournalRepoProc.updateSyncStatus(paramVO);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u51ed\u8bc1\u540c\u6b65\u72b6\u6001\u5f02\u5e38,{}", (Throwable)e);
            throw new BusinessException("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001\u5f02\u5e38\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            this.finAccountEngineJdbcService.closeConnection(connection);
        }
        return ApiResult.ok();
    }

    public ApiResult<Void> updateSyncStatusBatch(FinJournalSyncRpcParam param) {
        log.info("\u51ed\u8bc1\u540c\u6b65\u72b6\u6001\u56de\u5199, \u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString((Object)param));
        if (CollectionUtils.isEmpty((Collection)param.getIdList())) {
            return ApiResult.fail((String)"ID\u5217\u8868\u4e3a\u7a7a");
        }
        this.finJournalRepoProc.updateSyncStatusBatch(param);
        return ApiResult.ok();
    }

    @Transactional
    public ApiResult<Void> deleteByBillId(@RequestBody FinJournalSyncRpcParam param) {
        log.info("\u51ed\u8bc1\u5220\u9664\u7ea2\u51b2\u56de\u5199, \u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString((Object)param));
        if (StringUtils.isEmpty((CharSequence)param.getBillId())) {
            return ApiResult.fail((String)"\u51ed\u8bc1ID\u4e3a\u7a7a");
        }
        FinJournalRpcParam rpcParam = new FinJournalRpcParam();
        rpcParam.setBillId(param.getBillId());
        List<FinJournalDTO> journalDTOList = this.finJournalRepoProc.findWaitSyncJournal(rpcParam);
        this.finJournalRepoProc.deleteByBillId(param.getBillId());
        List<Long> engineIdList = journalDTOList.stream().map(FinJournalDTO::getAccountEngineId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(engineIdList)) {
            return ApiResult.fail((String)"\u4f1a\u8ba1\u5f15\u64ceID\u4e0d\u5b58\u5728");
        }
        Map<Long, FinJournalDTO> engineMap = journalDTOList.stream().collect(Collectors.toMap(BaseModelDTO::getId, t -> t));
        List<FinEventTableDTO> tableDOS = this.finEventTableRepoProc.findByEngineId(engineIdList);
        Map<Long, FinEventTableDTO> tableMap = tableDOS.stream().collect(Collectors.toMap(FinEventTableDTO::getEngineId, t -> t));
        Connection connection = null;
        try {
            connection = this.finAccountEngineJdbcService.getEventTableConnection(FinEventTableConvert.INSTANCE.DTOToDO(tableDOS.get(0)));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", (Object)tableDOS.get(0), (Object)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38");
        }
        try {
            for (FinJournalDTO journalDTO : journalDTOList) {
                FinEventTableDTO tableDTO = tableMap.get(journalDTO.getAccountEngineId());
                if (tableDTO != null) {
                    try {
                        String updateProposedStatusSql = "update " + tableDTO.getDatabaseName() + "." + tableDTO.getMasTable() + " set transfer_status = 'WAIT',  set proposed_status = 'DRAFT' where " + tableDTO.getColumnDocNum() + " = '" + journalDTO.getDocNum() + "'";
                        PreparedStatement preparedStatement = connection.prepareStatement(updateProposedStatusSql);
                        log.info("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001sql:\n{}", (Object)updateProposedStatusSql);
                        int res = preparedStatement.executeUpdate();
                        preparedStatement.close();
                    }
                    catch (SQLException e) {
                        log.error("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38, {}", (Throwable)e);
                        throw new BusinessException("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                }
                if (journalDTO.getAccountEngineDetailsId() == null) continue;
                this.finAccountEngineDetailsRepoProc.updateProposedType(journalDTO.getAccountEngineDetailsId());
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38,{}", (Throwable)e);
            throw new BusinessException("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            this.finAccountEngineJdbcService.closeConnection(connection);
        }
        return ApiResult.ok();
    }

    @Transactional
    public ApiResult<Void> deleteByIdList(@RequestBody FinJournalSyncRpcParam param) {
        log.info("\u51ed\u8bc1\u5220\u9664\u7ea2\u51b2\u56de\u5199, \u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString((Object)param));
        if (CollectionUtils.isEmpty((Collection)param.getIdList())) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        FinJournalRpcParam rpcParam = new FinJournalRpcParam();
        rpcParam.setIdList(param.getIdList());
        List<FinJournalDTO> journalDTOList = this.finJournalRepoProc.findWaitSyncJournal(rpcParam);
        this.finJournalRepoProc.deleteByIdList(param.getIdList());
        List<Long> engineIdList = journalDTOList.stream().map(FinJournalDTO::getAccountEngineId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(engineIdList)) {
            return ApiResult.fail((String)"\u4f1a\u8ba1\u5f15\u64ceID\u4e0d\u5b58\u5728");
        }
        Map<Long, FinJournalDTO> engineMap = journalDTOList.stream().collect(Collectors.toMap(BaseModelDTO::getId, t -> t));
        List<FinEventTableDTO> tableDOS = this.finEventTableRepoProc.findByEngineId(engineIdList);
        Map<Long, FinEventTableDTO> tableMap = tableDOS.stream().collect(Collectors.toMap(FinEventTableDTO::getEngineId, t -> t));
        Connection connection = null;
        try {
            connection = this.finAccountEngineJdbcService.getEventTableConnection(FinEventTableConvert.INSTANCE.DTOToDO(tableDOS.get(0)));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", (Object)tableDOS.get(0), (Object)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38");
        }
        try {
            for (FinJournalDTO journalDTO : journalDTOList) {
                FinEventTableDTO tableDTO = tableMap.get(journalDTO.getAccountEngineId());
                if (tableDTO != null) {
                    try {
                        String updateProposedStatusSql = "update " + tableDTO.getDatabaseName() + "." + tableDTO.getMasTable() + " set transfer_status = '" + (StringUtils.isNotEmpty((CharSequence)param.getTransferStatus()) ? param.getTransferStatus() : "WAIT") + "',  set proposed_status = '" + (StringUtils.isNotEmpty((CharSequence)param.getProposedStatus()) ? param.getProposedStatus() : "DRAFT") + "' where " + tableDTO.getColumnDocNum() + " = '" + journalDTO.getDocNum() + "'";
                        PreparedStatement preparedStatement = connection.prepareStatement(updateProposedStatusSql);
                        log.info("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001sql:\n{}", (Object)updateProposedStatusSql);
                        int res = preparedStatement.executeUpdate();
                        preparedStatement.close();
                    }
                    catch (SQLException e) {
                        log.error("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38, {}", (Throwable)e);
                        throw new BusinessException("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                }
                if (journalDTO.getAccountEngineDetailsId() == null) continue;
                this.finAccountEngineDetailsRepoProc.updateProposedType(journalDTO.getAccountEngineDetailsId());
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38,{}", (Throwable)e);
            throw new BusinessException("\u66f4\u65b0\u4f20\u5e10\u72b6\u6001,\u62df\u5b9a\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            this.finAccountEngineJdbcService.closeConnection(connection);
        }
        return ApiResult.ok();
    }

    public JournalGenerateRpcServiceImpl(JournalGenerateService journalGenerateService, FinJournalRepoProc finJournalRepoProc, FinFlexibleValueRepo finFlexibleValueRepo, FinSetOfBookRepo finSetOfBookRepo, FinSetOfBookLineRepo finSetOfBookLineRepo, FinJournalRepo finJournalRepo, FinEventTableRepoProc finEventTableRepoProc, FinAccountEngineJdbcService finAccountEngineJdbcService, FinAccountEngineDetailsRepoProc finAccountEngineDetailsRepoProc) {
        this.journalGenerateService = journalGenerateService;
        this.finJournalRepoProc = finJournalRepoProc;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
        this.finSetOfBookRepo = finSetOfBookRepo;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
        this.finJournalRepo = finJournalRepo;
        this.finEventTableRepoProc = finEventTableRepoProc;
        this.finAccountEngineJdbcService = finAccountEngineJdbcService;
        this.finAccountEngineDetailsRepoProc = finAccountEngineDetailsRepoProc;
    }
}

