package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 应收收款核销申请单.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Entity
@Table(name = "fin_ar_rec_ver_apply_settle",
        indexes = {
                @Index(name = "idx_masId", columnList = "masId")
        })
@DynamicInsert
@DynamicUpdate
@Comment("应收收款核销申请单明细拆分")
@Getter
@Setter
@Accessors(chain = true)
public class FinArRecVerApplySettleDO extends BaseModel {

    private static final long serialVersionUID = 3738208013374910134L;

    @Comment("主表ID")
    @Column()
    private Long masId;

    @Comment("应收单ID")
    @Column()
    private Long arId;

    @Comment("应收单单号")
    @Column(length = 32)
    private String arDocNo;

    @Comment("外部应收单ID")
    @Column(length = 32)
    private String outArId;

    @Comment("外部应收单单号")
    @Column(length = 32)
    private String outArDocNo;

    @Comment("应收单明细ID")
    @Column(name = "ar_d_id")
    private Long arDId;

    @Comment("外部应收单明细ID")
    @Column(name = "out_ar_d_id", length = 32)
    private String outArDId;

    @Comment("应收客户编码")
    @Column(length = 32)
    private String arCustCode;

    @Comment("收款单ID")
    @Column()
    private Long recId;

    @Comment("收款单单号")
    @Column(length = 32)
    private String recDocNo;

    @Comment("外部收款单ID")
    @Column(length = 32)
    private String outRecId;

    @Comment("外部收款单单号")
    @Column(length = 32)
    private String outRecDocNo;

    @Comment("收款单明细ID")
    @Column(name = "rec_d_id")
    private Long recDId;

    @Comment("外部收款单明细ID")
    @Column(name = "out_rec_d_id", length = 32)
    private String outRecDId;

    @Comment("收款客户编码")
    @Column(length = 32)
    private String recCustCode;

    @Comment("核销处理编号")
    @Column(length = 32)
    private String batchNo;

    @Comment("应收单未核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal arNotVerAmt;

    @Comment("收款单未核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal recNotVerAmt;

    @Comment("核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal verAmt;

    @Comment("核销标记，1：应收单和收款单核销，2：消核销，3：应收单和应收单对冲或收款单和收款单对冲")
    private String verFlag;

    @Comment("公司编码")
    @Column(columnDefinition = "varchar(32)")
    private String ouCode;

    @Comment("公司ID")
    @Column(columnDefinition = "bigint(20)")
    private Long ouId;

    @Comment("公司名称")
    @Column(columnDefinition = "varchar(32)")
    private String ouName;

    @Column(name = "rec_in_out_cust", columnDefinition = "varchar(40)  comment '收款单内外部客户'")
    private String recInOutCust;

    @Column(name = "rec_relevance_ou_code", columnDefinition = "varchar(32) comment '收款单关联公司编码'")
    private String recRelevanceOuCode;

    @Column(name = "ar_in_out_cust", columnDefinition = "varchar(40)  comment '应收单内外部客户'")
    private String arInOutCust;

    @Column(name = "ar_relevance_ou_code", columnDefinition = "varchar(32) comment '应收单关联公司编码'")
    private String arRelevanceOuCode;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof FinArRecVerApplySettleDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
