package com.elitesland.fin.application.service.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.creditaccount.CreditAutoRepaymentConditionConvert;
import com.elitesland.fin.application.convert.creditaccount.CreditSettingConvert;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAutoRepaymentConditionSaveParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditSettingParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAutoRepaymentConditionRespVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditSettingDetailVO;
import com.elitesland.fin.application.service.redis.MyRedisService;
import com.elitesland.fin.common.FinRedisConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAutoRepaymentConditionDO;
import com.elitesland.fin.entity.creditaccount.CreditSettingDO;
import com.elitesland.fin.repo.creditaccount.CreditAutoRepaymentConditionRepo;
import com.elitesland.fin.repo.creditaccount.CreditAutoRepaymentConditionRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditSettingRepo;
import com.elitesland.fin.repo.creditaccount.CreditSettingRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;
@Slf4j
@Service
@RequiredArgsConstructor
public class CreditSettingServiceImpl implements CreditSettingService {

    private final CreditSettingRepo creditSettingRepo;
    private final CreditSettingRepoProc creditSettingRepoProc;
    private final CreditAutoRepaymentConditionRepo autoRepaymentConditionRepo;
    private final CreditAutoRepaymentConditionRepoProc autoRepaymentConditionRepoProc;
    private final UdcProvider udcProvider;
    private final MyRedisService myRedisService;
    @Override
    @SysCodeProc
    public CreditSettingDetailVO detail() {
        CreditSettingDetailVO detailVO = creditSettingRepoProc.findAll();
        Map<String, String> conditionTypeUdc = udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());

        //自动还款设置条件明细
        if (Objects.nonNull(detailVO)){
            detailVO.setAutoRepaymentRespVOList(Collections.emptyList());
            List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList = autoRepaymentConditionRepo.findAllByMasId(detailVO.getId());
            if (CollectionUtil.isNotEmpty(autoRepaymentConditionDOList)){
                List<CreditAutoRepaymentConditionRespVO> autoRepaymentConditionRespVOList = autoRepaymentConditionDOList.stream().filter(Objects::nonNull).map(CreditAutoRepaymentConditionConvert.INSTANCE::doToVo).collect(Collectors.toList());
                autoRepaymentConditionRespVOList.forEach(respVO -> {
                    respVO.setConditionTypeName(conditionTypeUdc.get(respVO.getConditionType()));
                });
                detailVO.setAutoRepaymentRespVOList(autoRepaymentConditionRespVOList);
            }
        }
        return detailVO;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long saveOrUpdate(CreditSettingParam param) {
        Assert.notBlank(param.getGeneralParam(), "常规参数设置不能为空");
        CreditSettingDetailVO detailVO = creditSettingRepoProc.findAll();
        /*if (ObjectUtil.isNotNull(detailVO) && ObjectUtil.equals(detailVO.getEnableFlag(), Boolean.TRUE)) {
            throw new BusinessException("参数已经设置过，不能重复设置");
        }*/
        CreditSettingDO saveDo = CreditSettingConvert.INSTANCE.saveParam2Do(param);
        saveDo.setEnableFlag(Boolean.TRUE);
        if (Objects.isNull(param.getPaymentPeriodFlag())){
            saveDo.setPaymentPeriodFlag(Boolean.TRUE);
        }
        CreditSettingDO save = creditSettingRepo.save(saveDo);

        //自动还款设置条件明细
        if (Objects.isNull(param.getAutoRepaymentFlag())){
            param.setAutoRepaymentFlag(false);
        }
        autoRepaymentConditionRepo.deleteAllByMasId(save.getId());
        if (param.getAutoRepaymentFlag()){
            List<CreditAutoRepaymentConditionSaveParam> autoRepaymentParamList = param.getAutoRepaymentParamList();
            if (CollectionUtil.isEmpty(autoRepaymentParamList)){
                throw new BusinessException("自动还款设置为是时,未设置还款条件");
            }
            Set<Integer> serialNums = new HashSet<>();
            autoRepaymentParamList.stream().forEach(item -> {
                Assert.notNull(item.getSerialNum(), "序号必填");
                Assert.notEmpty(item.getTableName(), "表单名称必填");
                Assert.notEmpty(item.getColumnName(), "字段名称必填");
                Assert.notEmpty(item.getConditionType(), "条件必填");
                Assert.notEmpty(item.getValueFrom(), "从值内容必填");

                Assert.isFalse(serialNums.contains(item.getSerialNum()), "序号不能重复");
                serialNums.add(item.getSerialNum());
            });

            List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList = autoRepaymentParamList.stream().map(saveParam -> {
                CreditAutoRepaymentConditionDO autoRepaymentConditionDO = CreditAutoRepaymentConditionConvert.INSTANCE.paramToDo(saveParam);
                autoRepaymentConditionDO.setMasId(save.getId());
                autoRepaymentConditionDO.setId(null);
                return autoRepaymentConditionDO;
            }).collect(Collectors.toList());
            autoRepaymentConditionRepo.saveAll(autoRepaymentConditionDOList);
        }
        return save.getId();
    }

    @Override
    public CreditSettingDetailVO detailNotUdc() {
        return myRedisService.getDataFromRedis(FinRedisConstant.CREDIT_SETTING_AND_AUTO_REPAYMENT_CONDITION,CreditSettingDetailVO.class,"自动还款设置",()->{
            CreditSettingDetailVO detailVO = creditSettingRepoProc.findAll();
            //Map<String, String> conditionTypeUdc = udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
            //自动还款设置条件明细
            if (Objects.nonNull(detailVO)){
                detailVO.setAutoRepaymentRespVOList(Collections.emptyList());
                List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList = autoRepaymentConditionRepo.findAllByMasId(detailVO.getId());
                if (CollectionUtil.isNotEmpty(autoRepaymentConditionDOList)){
                    List<CreditAutoRepaymentConditionRespVO> autoRepaymentConditionRespVOList = autoRepaymentConditionDOList.stream().filter(Objects::nonNull).map(CreditAutoRepaymentConditionConvert.INSTANCE::doToVo).collect(Collectors.toList());
                  /*  autoRepaymentConditionRespVOList.forEach(respVO -> {
                        respVO.setConditionTypeName(conditionTypeUdc.get(respVO.getConditionType()));
                    });*/
                    detailVO.setAutoRepaymentRespVOList(autoRepaymentConditionRespVOList);
                }
            }
            return detailVO;
        });
    }
}
