package com.elitesland.fin.application.service.unionpay.config;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.secss.SecssUtil;
import com.google.common.base.Charsets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.net.URLDecoder;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author sunxw
 * @description 获取签名、解签结果(安全式)
 * @Date 2023/6/4
 */
@Slf4j
@Component
public class UnionPaySecssUtil {


    @Autowired
    private SecssUtil secssUtil;

    /**
     * 获取签名
     * @param req
     * @return
     */
    public synchronized String getSign(TreeMap<String,Object> req){
        secssUtil.sign(req);
        log.info("待签名信息is {}，签名响应: {}",secssUtil.getErrCode(),secssUtil.getErrMsg());
        String sign = secssUtil.getSign();
        return sign;
    }

    /**
     * 获取解密后的字符串
     * @param encData
     * @return
     */
    public synchronized String getDecData(String encData){
        try {
            String cardTranData = URLDecoder.decode(encData, Charsets.UTF_8);
            secssUtil.decryptData(cardTranData);
            String cardData = secssUtil.getDecValue();
            if (StringUtils.isNotEmpty(cardData)){
                Map map = JSONObject.parseObject(cardData, Map.class);
                return (String)map.get("CardNo");
            }else {
                return "";
            }
        }catch (Exception e){
            log.warn("银行账户字段解签错误");
            return "";
        }
    }

}
