package com.elitesland.fin.infr.repo.paymentperiod;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangePageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangePagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;
import com.elitesland.fin.domain.entity.paymentperiod.QAgingRangeDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class AgingRangeRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QAgingRangeDO qAgingRangeDO = QAgingRangeDO.agingRangeDO;

    public PagingVO<AgingRangePagingVO> page(AgingRangePageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AgingRangePagingVO> query = select(AgingRangePagingVO.class).where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qAgingRangeDO);
        return PagingVO.<AgingRangePagingVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public List<AgingRangeVO> selectListByParam(AgingRangePageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AgingRangeVO> query = select(AgingRangeVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    public AgingRangeVO checkSelectByParam(AgingRangePageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<AgingRangeVO> jpaQuery = select(AgingRangeVO.class).where(ExpressionUtils.allOf(where));

        return jpaQuery.fetchFirst();
    }

    private List<Predicate> where(AgingRangePageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();



        if (!StringUtils.isEmpty(pageParam.getTimeUnitType())) {
            predicates.add(qAgingRangeDO.timeUnitType.eq(pageParam.getTimeUnitType()));
        }
        if(CollectionUtils.isNotEmpty(pageParam.getTimeUnitTypeList())){
            predicates.add(qAgingRangeDO.timeUnitType.in(pageParam.getTimeUnitTypeList()));
        }
        if (!StringUtils.isEmpty(pageParam.getAgingRangeCode())) {
            predicates.add(qAgingRangeDO.agingRangeCode.eq(pageParam.getAgingRangeCode()));
        }
        if(CollectionUtils.isNotEmpty(pageParam.getAgingRangeCodeList())){
            predicates.add(qAgingRangeDO.agingRangeCode.in(pageParam.getAgingRangeCodeList()));
        }

        if (!StringUtils.isEmpty(pageParam.getAgingRangeName())) {
            predicates.add(qAgingRangeDO.agingRangeName.eq(pageParam.getAgingRangeName()));
        }
        if (!StringUtils.isEmpty(pageParam.getAgingRangeNameKeyword())) {
            predicates.add(qAgingRangeDO.agingRangeName.like("%" + pageParam.getAgingRangeNameKeyword() + "%"));
        }
        if (!StringUtils.isEmpty(pageParam.getAgingRangeKeyword())) {
            predicates.add(qAgingRangeDO.agingRangeCode.like("%" + pageParam.getAgingRangeKeyword() + "%").or(qAgingRangeDO.agingRangeName.like("%" + pageParam.getAgingRangeKeyword() + "%")));
        }

        if (!StringUtils.isEmpty(pageParam.getStatus())) {
            predicates.add(qAgingRangeDO.status.eq(pageParam.getStatus()));
        }
        if(CollectionUtils.isNotEmpty(pageParam.getStatusList())){
            predicates.add(qAgingRangeDO.status.in(pageParam.getStatusList()));
        }
        if (Objects.nonNull(pageParam.getUnitDays())) {
            predicates.add(qAgingRangeDO.unitDays.eq(pageParam.getUnitDays()));
        }


        if (Objects.nonNull(pageParam.getId())){
            predicates.add(qAgingRangeDO.id.eq(pageParam.getId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getIdList())) {
            predicates.add(qAgingRangeDO.id.in(pageParam.getIdList()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAgingRangeDO.id,
                qAgingRangeDO.agingRangeCode,
                qAgingRangeDO.agingRangeName,
                qAgingRangeDO.timeUnitType,
                qAgingRangeDO.unitDays,
                qAgingRangeDO.status,
                qAgingRangeDO.remark,
                qAgingRangeDO.createTime,
                qAgingRangeDO.createUserId,
                qAgingRangeDO.creator,
                qAgingRangeDO.modifyTime,
                qAgingRangeDO.modifyUserId,
                qAgingRangeDO.updater,
                qAgingRangeDO.deleteFlag
        )).from(qAgingRangeDO);
    }


    public void updateStatusBatch(String status, List<Long> ids) {
        jpaQueryFactory.update(qAgingRangeDO)
                .set(qAgingRangeDO.status, status)
                .where(qAgingRangeDO.id.in(ids))
                .execute();
    }

    public void updateStatusById(String status, Long id) {
        jpaQueryFactory.update(qAgingRangeDO)
                .set(qAgingRangeDO.status, status)
                .where(qAgingRangeDO.id.eq(id))
                .execute();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qAgingRangeDO)
                .set(qAgingRangeDO.deleteFlag, deleteFlag)
                .where(qAgingRangeDO.id.in(ids))
                .execute();
    }
}
