package com.elitesland.fin.repo.creditaccount;


import com.elitesland.fin.entity.creditaccount.CreditAccountRuleConfigDtlDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountRuleConfigDtlDO;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Slf4j
@Component
@AllArgsConstructor
public class CreditAccountRuleConfigDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountRuleConfigDtlDO jpaQDO = QCreditAccountRuleConfigDtlDO.creditAccountRuleConfigDtlDO;

    public void updateDynamically(List<CreditAccountRuleConfigDtlDO> accountRuleConfigDtlDOList) {
        for (CreditAccountRuleConfigDtlDO param : accountRuleConfigDtlDOList) {
            JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDO);
            if (StringUtils.isNotBlank(param.getIoCode())) {
                updateClause.set(jpaQDO.ioCode, param.getIoCode());
            }
            if (param.getPriorityNo() != null) {
                updateClause.set(jpaQDO.priorityNo, param.getPriorityNo());
            }
            updateClause.set(jpaQDO.modifyTime, LocalDateTime.now());
            updateClause.where(jpaQDO.id.eq(param.getId())).execute();
        }
    }

    public void deleteByParam(CreditAccountRuleConfigDtlDO accountRuleConfigDtlDO) {
        JPADeleteClause jpaDeleteClause = jpaQueryFactory.delete(jpaQDO);
        if (accountRuleConfigDtlDO.getMasId() != null) {
            jpaDeleteClause.where(jpaQDO.masId.eq(accountRuleConfigDtlDO.getMasId()));
        }
        jpaDeleteClause.execute();


    }

}