package com.elitesland.fin.application.facade.param.account;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author sunxw
 * @description 账户储值新增param
 * @Date 2023/5/19
 */
@Data
public class AccountStorageSaveParam extends BaseViewModel {

    @ApiModelProperty("支付流水号")
    private String payOrderId;

    @ApiModelProperty("单据类型 yst-fin:STORED_ORDER_TYPE")
    private String receiptType;

    @ApiModelProperty("单据状态 yst-fin:RECORDER_STATE")
    private String receiptStatus;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    private Long ouId;

    @ApiModelProperty("归属公司")
    private String ouName;

    @ApiModelProperty("归属公司编码")
    private String secOuCode;

    @ApiModelProperty("归属公司名称")
    private String secOuName;

    @ApiModelProperty("归属加盟商")
    private String franchisee;

    @ApiModelProperty("归属加盟商名称")
    private String franchiseeName;

    @ApiModelProperty("汇款主体名称")
    private String remitter;

    @ApiModelProperty("汇款银行编码")
    private String remitterBankCode;

    @ApiModelProperty("汇款银行名称")
    private String remitterBankName;

    @ApiModelProperty("汇款银行账号")
    private String remitterAccount;

    @ApiModelProperty("汇款日期")
    private String remitterDate;

    @ApiModelProperty("支付方式 yst-fin:PAY_METHOD")
    private String payMode;

    @ApiModelProperty("汇款金额")
    private BigDecimal remitterAmt;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("汇款主体类型")
    private String remitterTypeName;

}
