package com.elitesland.fin.application.service.writeoff;


import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyApQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
public interface FinApPayVerApplyApService {

    /**
     * 批量插入.
     *
     * @param masId    主表ID
     * @param saveList 数据集合
     */
    void createBatch(Long masId, List<FinApPayVerApplyApSaveDTO> saveList);

    /**
     * 批量删除.
     *
     * @param masIds 主表ID集合
     */
    void deleteByMasId(Collection<Long> masIds);

    /**
     * 数据查询.
     *
     * @param masIds 主表ID集合
     * @return 数据集合
     */
    List<FinApPayVerApplyApVO> listByMasIds(Collection<Long> masIds);

	/**
	 * 根据条件查询核销应收单明细
	 * @param query
	 * @return
	 */
	List<FinApPayVerApplyApVO> listByQuery(FinApPayVerApplyApQuery query);

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	List<FinApPayVerApplyApVO> listByOutArDocNoOrDId(FinApPayVerApplyQuery applyQuery);

}
